/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component.behavior;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.StateHelper;
import javax.faces.component.UIComponentBase;
import javax.faces.component.behavior.ClientBehaviorBase;
import javax.faces.context.FacesContext;
import org.richfaces.component.behavior.BehaviorStateHelper;

public abstract class ClientBehavior
extends ClientBehaviorBase {
    private StateHelper behaviorStateHelper = null;
    private Map<String, ValueExpression> bindings;

    public StateHelper getStateHelper() {
        if (this.behaviorStateHelper == null) {
            this.behaviorStateHelper = new BehaviorStateHelper(this);
        }
        return this.behaviorStateHelper;
    }

    public ValueExpression getValueExpression(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.bindings == null ? null : this.bindings.get(name);
    }

    public void setValueExpression(String name, ValueExpression valueExpression) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (valueExpression != null) {
            if (valueExpression.isLiteralText()) {
                this.setLiteralValue(name, valueExpression);
            } else {
                if (this.bindings == null) {
                    this.bindings = new HashMap<String, ValueExpression>(6, 1.0f);
                }
                this.bindings.put(name, valueExpression);
            }
        } else if (this.bindings != null) {
            this.bindings.remove(name);
            if (this.bindings.isEmpty()) {
                this.bindings = null;
            }
        }
        this.clearInitialState();
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    public void setLiteralValue(String name, ValueExpression expression) {
        assert (expression.isLiteralText());
        ELContext context = this.getFacesContext().getELContext();
        try {
            this.setLiteralAttribute(name, expression.getValue(context));
        }
        catch (ELException elem) {
            throw new FacesException(elem);
        }
    }

    public abstract void setLiteralAttribute(String var1, Object var2);

    @Override
    public Object saveState(FacesContext context) {
        Object[] state = null;
        Object parentState = super.saveState(context);
        if (this.initialStateMarked()) {
            if (parentState != null) {
                state = new Object[]{parentState};
            }
        } else {
            Object savedHelper = null;
            if (this.behaviorStateHelper != null) {
                savedHelper = this.behaviorStateHelper.saveState(context);
            }
            state = new Object[]{parentState, savedHelper, ClientBehavior.saveBindings(context, this.bindings)};
        }
        return state;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (state != null) {
            Object[] stateObject = (Object[])state;
            super.restoreState(context, stateObject[0]);
            if (stateObject.length == 3) {
                this.getStateHelper().restoreState(context, stateObject[1]);
                this.bindings = ClientBehavior.restoreBindings(context, stateObject[2]);
                this.clearInitialState();
            }
        }
    }

    private static Object saveBindings(FacesContext context, Map<String, ValueExpression> bindings) {
        if (bindings == null) {
            return null;
        }
        Object[] values = new Object[2];
        values[0] = bindings.keySet().toArray(new String[bindings.size()]);
        Object[] bindingValues = bindings.values().toArray();
        for (int i = 0; i < bindingValues.length; ++i) {
            bindingValues[i] = UIComponentBase.saveAttachedState(context, bindingValues[i]);
        }
        values[1] = bindingValues;
        return values;
    }

    private static Map<String, ValueExpression> restoreBindings(FacesContext context, Object state) {
        if (state == null) {
            return null;
        }
        Object[] values = (Object[])state;
        String[] names = (String[])values[0];
        Object[] states = (Object[])values[1];
        HashMap<String, ValueExpression> bindings = new HashMap<String, ValueExpression>();
        for (int i = 0; i < names.length; ++i) {
            bindings.put(names[i], (ValueExpression)UIComponentBase.restoreAttachedState(context, states[i]));
        }
        return bindings;
    }

    protected boolean compare(Serializable key, String name) {
        boolean retValue = false;
        if (key != null) {
            String keyName = key.toString();
            retValue = keyName.equals(name);
        }
        return retValue;
    }
}

