/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.math.BigDecimal;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

public final class NumberUtils {
    private static final Logger LOGGER = RichfacesLogger.COMPONENTS.getLogger();

    private NumberUtils() {
    }

    public static Number getNumber(Object v) {
        Number result = null;
        if (v != null) {
            try {
                if (v instanceof String) {
                    result = Double.parseDouble((String)v);
                } else {
                    Number n = (Number)v;
                    if (n instanceof BigDecimal || n instanceof Double || n instanceof Float) {
                        result = Float.valueOf(n.floatValue());
                    } else if (n instanceof Integer || n instanceof Long) {
                        result = n.longValue();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), e);
            }
            return result;
        }
        return new Integer(0);
    }
}

