/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.richfaces.PanelMenuMode;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.EventName;
import org.richfaces.component.AbstractPanelMenuItem;
import org.richfaces.component.attribute.AjaxProps;
import org.richfaces.component.attribute.BypassProps;
import org.richfaces.component.attribute.EventsMouseProps;
import org.richfaces.component.attribute.StyleClassProps;
import org.richfaces.component.attribute.StyleProps;
import org.richfaces.event.ItemChangeEvent;
import org.richfaces.event.PanelToggleEvent;

public abstract class AbstractPanelMenuGroup
extends AbstractPanelMenuItem
implements AjaxProps,
BypassProps,
EventsMouseProps,
StyleProps,
StyleClassProps {
    public static final String COMPONENT_TYPE = "org.richfaces.PanelMenuGroup";
    public static final String COMPONENT_FAMILY = "org.richfaces.PanelMenuGroup";
    private Boolean submittedExpanded;
    private boolean valueChanged;

    protected AbstractPanelMenuGroup() {
        this.setRendererType("org.richfaces.PanelMenuGroupRenderer");
    }

    @Override
    public String getFamily() {
        return "org.richfaces.PanelMenuGroup";
    }

    @Override
    public void processDecodes(FacesContext context) {
        super.processDecodes(context);
        this.executeValidate(context);
    }

    private boolean isValueChanged() {
        return this.valueChanged;
    }

    private void setValueChanged(boolean valueChanged) {
        this.valueChanged = valueChanged;
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Boolean expanded = this.getSubmittedExpanded();
        if (expanded == null) {
            this.setValueChanged(false);
            return;
        }
        Boolean previous = (Boolean)this.getValue();
        this.setExpanded(expanded);
        this.setSubmittedExpanded(null);
        this.setValueChanged(!expanded.equals(previous));
        if (previous != null && this.isValueChanged()) {
            if (expanded.booleanValue() && this.getMode() == PanelMenuMode.server && this.getPanelMenu().isExpandSingle()) {
                this.collapseOtherTopGroups();
            }
            this.queueEvent(new PanelToggleEvent(this, previous));
        }
    }

    private AbstractPanelMenuGroup getTopGroup() {
        AbstractPanelMenuGroup c = this;
        while (c.getParent() instanceof AbstractPanelMenuGroup) {
            c = (AbstractPanelMenuGroup)c.getParent();
        }
        return c;
    }

    private void collapseOtherTopGroups() {
        AbstractPanelMenuGroup topGroup = this.getTopGroup();
        for (UIComponent child : this.getPanelMenu().getChildren()) {
            AbstractPanelMenuGroup group;
            if (!(child instanceof AbstractPanelMenuGroup) || (group = (AbstractPanelMenuGroup)child) == topGroup) continue;
            group.setSubmittedExpanded(null);
            group.setExpanded(false);
        }
    }

    private void executeValidate(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    @Override
    public void queueEvent(FacesEvent event) {
        if (event instanceof ItemChangeEvent && event.getComponent() == this) {
            this.setEventPhase(event);
        }
        super.queueEvent(event);
    }

    protected void setEventPhase(FacesEvent event) {
        if (this.isImmediate()) {
            event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        } else if (this.isBypassUpdates()) {
            event.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
        } else {
            event.setPhaseId(PhaseId.INVOKE_APPLICATION);
        }
    }

    public Boolean getSubmittedExpanded() {
        return this.submittedExpanded;
    }

    public void setSubmittedExpanded(Object submittedValue) {
        this.submittedExpanded = Boolean.parseBoolean(String.valueOf(submittedValue));
    }

    @Attribute
    public Boolean isExpanded() {
        return (Boolean)this.getValue();
    }

    public void setExpanded(boolean expanded) {
        this.setValue(expanded);
    }

    @Override
    public void setValueExpression(String name, ValueExpression binding) {
        if ("expanded".equals(name)) {
            super.setValueExpression("value", binding);
        } else {
            super.setValueExpression(name, binding);
        }
    }

    @Override
    public boolean isImmediate() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.immediate), false);
    }

    @Override
    public void setImmediate(boolean immediate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.immediate), immediate);
    }

    @Override
    @Attribute(defaultValue="Boolean.FALSE")
    public abstract Boolean getSelectable();

    @Override
    @Attribute(defaultValue="getPanelMenu().getGroupMode()")
    public abstract PanelMenuMode getMode();

    @Attribute
    public abstract String getCollapseEvent();

    @Attribute
    public abstract String getExpandEvent();

    @Attribute(generate=false)
    public String getLeftCollapsedIcon() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.leftCollapsedIcon), this.isTopItem() ? this.getPanelMenu().getTopGroupCollapsedLeftIcon() : this.getPanelMenu().getGroupCollapsedLeftIcon());
    }

    public void setLeftCollapsedIcon(String leftCollapsedIcon) {
        this.getStateHelper().put((Serializable)((Object)Properties.leftCollapsedIcon), leftCollapsedIcon);
    }

    @Override
    @Attribute(generate=false)
    public String getLeftDisabledIcon() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.leftDisabledIcon), this.isTopItem() ? this.getPanelMenu().getTopGroupDisabledLeftIcon() : this.getPanelMenu().getGroupDisabledLeftIcon());
    }

    @Override
    public void setLeftDisabledIcon(String leftDisabledIcon) {
        this.getStateHelper().put((Serializable)((Object)Properties.leftDisabledIcon), leftDisabledIcon);
    }

    @Attribute(generate=false)
    public String getLeftExpandedIcon() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.leftExpandedIcon), this.isTopItem() ? this.getPanelMenu().getTopGroupExpandedLeftIcon() : this.getPanelMenu().getGroupExpandedLeftIcon());
    }

    public void setLeftExpandedIcon(String leftExpandedIcon) {
        this.getStateHelper().put((Serializable)((Object)Properties.leftExpandedIcon), leftExpandedIcon);
    }

    @Attribute(generate=false)
    public String getRightCollapsedIcon() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.rightCollapsedIcon), this.isTopItem() ? this.getPanelMenu().getTopGroupCollapsedRightIcon() : this.getPanelMenu().getGroupCollapsedRightIcon());
    }

    public void setRightCollapsedIcon(String rightCollapsedIcon) {
        this.getStateHelper().put((Serializable)((Object)Properties.rightCollapsedIcon), rightCollapsedIcon);
    }

    @Override
    @Attribute(generate=false)
    public String getRightDisabledIcon() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.rightDisabledIcon), this.isTopItem() ? this.getPanelMenu().getTopGroupDisabledRightIcon() : this.getPanelMenu().getGroupDisabledRightIcon());
    }

    @Override
    public void setRightDisabledIcon(String rightDisabledIcon) {
        this.getStateHelper().put((Serializable)((Object)Properties.rightDisabledIcon), rightDisabledIcon);
    }

    @Attribute(generate=false)
    public String getRightExpandedIcon() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.rightExpandedIcon), this.isTopItem() ? this.getPanelMenu().getTopGroupExpandedRightIcon() : this.getPanelMenu().getGroupExpandedRightIcon());
    }

    public void setRightExpandedIcon(String rightExpandedIcon) {
        this.getStateHelper().put((Serializable)((Object)Properties.rightExpandedIcon), rightExpandedIcon);
    }

    @Attribute(events={@EventName(value="collapse")})
    public abstract String getOncollapse();

    @Attribute(events={@EventName(value="expand")})
    public abstract String getOnexpand();

    @Attribute(events={@EventName(value="switch")})
    public abstract String getOnswitch();

    @Attribute(events={@EventName(value="beforecollapse")})
    public abstract String getOnbeforecollapse();

    @Attribute(events={@EventName(value="beforeexpand")})
    public abstract String getOnbeforeexpand();

    @Attribute(events={@EventName(value="beforeswitch")})
    public abstract String getOnbeforeswitch();

    @Override
    @Attribute(generate=false)
    public String getDisabledClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.disabledClass), this.isTopItem() ? this.getPanelMenu().getTopGroupDisabledClass() : this.getPanelMenu().getGroupDisabledClass());
    }

    @Override
    public void setDisabledClass(String disabledClass) {
        this.getStateHelper().put((Serializable)((Object)Properties.disabledClass), disabledClass);
    }

    @Override
    @Attribute
    public abstract String getLeftIconClass();

    @Override
    @Attribute
    public abstract String getRightIconClass();

    @Override
    @Attribute(hidden=true)
    public abstract String getLeftIcon();

    @Override
    @Attribute(hidden=true)
    public abstract String getRightIcon();

    @Override
    @Attribute(generate=false)
    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.styleClass), this.isTopItem() ? this.getPanelMenu().getTopGroupClass() : this.getPanelMenu().getGroupClass());
    }

    @Override
    public void setStyleClass(String styleClass) {
        this.getStateHelper().put((Serializable)((Object)Properties.styleClass), styleClass);
    }

    @Override
    @Attribute(events={@EventName(value="select")})
    public abstract String getOnselect();

    @Override
    @Attribute(events={@EventName(value="beforeselect")})
    public abstract String getOnbeforeselect();

    public boolean hasActiveItem(UIComponent component, String activeItem) {
        AbstractPanelMenuGroup group;
        AbstractPanelMenuItem item;
        if (activeItem == null) {
            return false;
        }
        if (component instanceof AbstractPanelMenuItem && activeItem.equals((item = (AbstractPanelMenuItem)component).getName())) {
            return true;
        }
        if (component instanceof AbstractPanelMenuGroup && !(group = (AbstractPanelMenuGroup)component).getPanelMenu().isBubbleSelection()) {
            return false;
        }
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                if (!child.isRendered() || !(child instanceof AbstractPanelMenuItem) || !this.hasActiveItem(child, activeItem)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean getState() {
        Boolean flag = this.isExpanded();
        return flag == null ? this.hasActiveItem(this, this.getPanelMenu().getActiveItem()) : flag.booleanValue();
    }

    @Override
    public void processUpdates(FacesContext context) {
        if (this.isValueChanged()) {
            ValueExpression ve = this.getValueExpression("value");
            ELContext elc = FacesContext.getCurrentInstance().getELContext();
            if (ve != null && !ve.isReadOnly(elc)) {
                ve.setValue(elc, this.isExpanded());
            }
        }
        super.processUpdates(context);
    }

    static enum Properties {
        leftDisabledIcon,
        leftExpandedIcon,
        rightCollapsedIcon,
        rightDisabledIcon,
        rightExpandedIcon,
        disabledClass,
        styleClass,
        leftCollapsedIcon;

    }

    private static enum PropertyKeys {
        selectable,
        immediate;

    }
}

