/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.xml.serializer;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.xml.transform.TransformerException;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.ajax4jsf.xml.serializer.ObjectFactory;
import org.ajax4jsf.xml.serializer.utils.SystemIDResolver;
import org.ajax4jsf.xml.serializer.utils.Utils;
import org.ajax4jsf.xml.serializer.utils.WrappedRuntimeException;

final class CharInfo {
    private Hashtable m_charToString = new Hashtable();
    public static final String HTML_ENTITIES_RESOURCE = "org.ajax4jsf.xml.serializer.HTMLEntities";
    public static final String XML_ENTITIES_RESOURCE = "org.ajax4jsf.xml.serializer.XMLEntities";
    public static final char S_HORIZONAL_TAB = '\t';
    public static final char S_LINEFEED = '\n';
    public static final char S_CARRIAGERETURN = '\r';
    final boolean onlyQuotAmpLtGt;
    private static final int ASCII_MAX = 128;
    private boolean[] isSpecialAttrASCII = new boolean[128];
    private boolean[] isSpecialTextASCII = new boolean[128];
    private boolean[] isCleanTextASCII = new boolean[128];
    private int[] array_of_bits = this.createEmptySetOfIntegers(65535);
    private static final int SHIFT_PER_WORD = 5;
    private static final int LOW_ORDER_BITMASK = 31;
    private int firstWordNotUsed;
    private CharKey m_charKey = new CharKey();
    private static Hashtable m_getCharInfoCache = new Hashtable();

    private CharInfo(String entitiesResource, String method) {
        this(entitiesResource, method, false);
    }

    private CharInfo(String entitiesResource, String method, boolean internal) {
        ResourceBundle entities = null;
        boolean noExtraEntities = true;
        if (internal) {
            try {
                entities = PropertyResourceBundle.getBundle(entitiesResource);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (entities != null) {
            Enumeration<String> keys = entities.getKeys();
            while (keys.hasMoreElements()) {
                String name = keys.nextElement();
                String value = entities.getString(name);
                int code = Integer.parseInt(value);
                this.defineEntity(name, (char)code);
                if (!this.extraEntity(code)) continue;
                noExtraEntities = false;
            }
            this.set(10);
            this.set(13);
        } else {
            InputStream is = null;
            try {
                BufferedReader reader;
                if (internal) {
                    is = URLToStreamHelper.urlToStreamSafe(CharInfo.class.getResource(entitiesResource));
                } else {
                    ClassLoader cl = ObjectFactory.findClassLoader();
                    is = cl == null ? URLToStreamHelper.urlToStreamSafe(ClassLoader.getSystemResource(entitiesResource)) : URLToStreamHelper.urlToStreamSafe(cl.getResource(entitiesResource));
                    if (is == null) {
                        try {
                            URL url = new URL(entitiesResource);
                            is = url.openStream();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (is == null) {
                    throw new RuntimeException(Utils.messages.createMessage("ER_RESOURCE_COULD_NOT_FIND", new Object[]{entitiesResource, entitiesResource}));
                }
                try {
                    reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    reader = new BufferedReader(new InputStreamReader(is));
                }
                String line = reader.readLine();
                while (line != null) {
                    if (line.length() == 0 || line.charAt(0) == '#') {
                        line = reader.readLine();
                        continue;
                    }
                    int index = line.indexOf(32);
                    if (index > 1) {
                        String name = line.substring(0, index);
                        if (++index < line.length()) {
                            String value = line.substring(index);
                            if ((index = value.indexOf(32)) > 0) {
                                value = value.substring(0, index);
                            }
                            int code = Integer.parseInt(value);
                            this.defineEntity(name, (char)code);
                            if (this.extraEntity(code)) {
                                noExtraEntities = false;
                            }
                        }
                    }
                    line = reader.readLine();
                }
                is.close();
                this.set(10);
                this.set(13);
            }
            catch (Exception e) {
                throw new RuntimeException(Utils.messages.createMessage("ER_RESOURCE_COULD_NOT_LOAD", new Object[]{entitiesResource, e.toString(), entitiesResource, e.toString()}));
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception except) {}
                }
            }
        }
        for (int ch = 0; ch < 128; ++ch) {
            if ((32 <= ch || 10 == ch || 13 == ch || 9 == ch) && !this.get(ch) || 34 == ch) {
                this.isCleanTextASCII[ch] = true;
                this.isSpecialTextASCII[ch] = false;
                continue;
            }
            this.isCleanTextASCII[ch] = false;
            this.isSpecialTextASCII[ch] = true;
        }
        this.onlyQuotAmpLtGt = noExtraEntities;
        for (int i = 0; i < 128; ++i) {
            this.isSpecialAttrASCII[i] = this.get(i);
        }
        if ("xml".equals(method)) {
            this.isSpecialAttrASCII[9] = true;
        }
    }

    private void defineEntity(String name, char value) {
        StringBuffer sb = new StringBuffer("&");
        sb.append(name);
        sb.append(';');
        String entityString = sb.toString();
        this.defineChar2StringMapping(entityString, value);
    }

    synchronized String getOutputStringForChar(char value) {
        this.m_charKey.setChar(value);
        return (String)this.m_charToString.get(this.m_charKey);
    }

    final boolean isSpecialAttrChar(int value) {
        if (value < 128) {
            return this.isSpecialAttrASCII[value];
        }
        return this.get(value);
    }

    final boolean isSpecialTextChar(int value) {
        if (value < 128) {
            return this.isSpecialTextASCII[value];
        }
        return this.get(value);
    }

    final boolean isTextASCIIClean(int value) {
        return this.isCleanTextASCII[value];
    }

    private static CharInfo getCharInfoBasedOnPrivilege(final String entitiesFileName, final String method, final boolean internal) {
        return (CharInfo)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new CharInfo(entitiesFileName, method, internal);
            }
        });
    }

    static CharInfo getCharInfo(String entitiesFileName, String method) {
        CharInfo charInfo = (CharInfo)m_getCharInfoCache.get(entitiesFileName);
        if (charInfo != null) {
            return charInfo;
        }
        try {
            charInfo = CharInfo.getCharInfoBasedOnPrivilege(entitiesFileName, method, true);
            m_getCharInfoCache.put(entitiesFileName, charInfo);
            return charInfo;
        }
        catch (Exception e) {
            try {
                return CharInfo.getCharInfoBasedOnPrivilege(entitiesFileName, method, false);
            }
            catch (Exception e2) {
                if (entitiesFileName.indexOf(58) < 0) {
                    String absoluteEntitiesFileName = SystemIDResolver.getAbsoluteURIFromRelative(entitiesFileName);
                } else {
                    try {
                        String absoluteEntitiesFileName = SystemIDResolver.getAbsoluteURI(entitiesFileName, null);
                    }
                    catch (TransformerException te) {
                        throw new WrappedRuntimeException(te);
                    }
                }
                return CharInfo.getCharInfoBasedOnPrivilege(entitiesFileName, method, false);
            }
        }
    }

    private static int arrayIndex(int i) {
        return i >> 5;
    }

    private static int bit(int i) {
        int ret = 1 << (i & 0x1F);
        return ret;
    }

    private int[] createEmptySetOfIntegers(int max) {
        this.firstWordNotUsed = 0;
        int[] arr = new int[CharInfo.arrayIndex(max - 1) + 1];
        return arr;
    }

    private final void set(int i) {
        this.setASCIIdirty(i);
        int j = i >> 5;
        int k = j + 1;
        if (this.firstWordNotUsed < k) {
            this.firstWordNotUsed = k;
        }
        int n = j;
        this.array_of_bits[n] = this.array_of_bits[n] | 1 << (i & 0x1F);
    }

    private final boolean get(int i) {
        boolean in_the_set = false;
        int j = i >> 5;
        if (j < this.firstWordNotUsed) {
            in_the_set = (this.array_of_bits[j] & 1 << (i & 0x1F)) != 0;
        }
        return in_the_set;
    }

    private boolean extraEntity(int entityValue) {
        boolean extra = false;
        if (entityValue < 128) {
            switch (entityValue) {
                case 34: 
                case 38: 
                case 60: 
                case 62: {
                    break;
                }
                default: {
                    extra = true;
                }
            }
        }
        return extra;
    }

    private void setASCIIdirty(int j) {
        if (0 <= j && j < 128) {
            this.isCleanTextASCII[j] = false;
            this.isSpecialTextASCII[j] = true;
        }
    }

    private void setASCIIclean(int j) {
        if (0 <= j && j < 128) {
            this.isCleanTextASCII[j] = true;
            this.isSpecialTextASCII[j] = false;
        }
    }

    private void defineChar2StringMapping(String outputString, char inputChar) {
        CharKey character = new CharKey(inputChar);
        this.m_charToString.put(character, outputString);
        this.set(inputChar);
    }

    private static class CharKey {
        private char m_char;

        public CharKey(char key) {
            this.m_char = key;
        }

        public CharKey() {
        }

        public final void setChar(char c) {
            this.m_char = c;
        }

        public final int hashCode() {
            return this.m_char;
        }

        public final boolean equals(Object obj) {
            return ((CharKey)obj).m_char == this.m_char;
        }
    }
}

