/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.el.ELContextWrapper;
import org.ajax4jsf.util.CapturingELResolver;
import org.ajax4jsf.util.GenericsIntrospectionCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELUtils {
    private ELUtils() {
    }

    public static boolean isValueReference(String value) {
        int end;
        if (value == null) {
            return false;
        }
        int start = value.indexOf("#{");
        return start >= 0 && (end = value.lastIndexOf(125)) >= 0 && start < end;
    }

    private static Class<?> resolveType(Type type) {
        Type actualType;
        ParameterizedType parameterizedType;
        Type[] types;
        Class result = Object.class;
        if (type instanceof ParameterizedType && (types = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()) != null && types.length != 0 && (actualType = types[0]) instanceof Class) {
            result = (Class)actualType;
        }
        return result;
    }

    private static BeanInfo getBeanInfo(Class<?> beanClass, GenericsIntrospectionCache.GenericsCacheEntry entry) {
        BeanInfo beanInfo = null;
        SoftReference<BeanInfo> beanInfoReference = entry.beanInfoReference;
        if (beanInfoReference != null) {
            beanInfo = beanInfoReference.get();
        }
        if (beanInfo == null) {
            try {
                beanInfo = Introspector.getBeanInfo(beanClass);
                entry.beanInfoReference = new SoftReference<BeanInfo>(beanInfo);
            }
            catch (IntrospectionException e) {
                throw new FacesException(e.getMessage(), e);
            }
        }
        return beanInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> getGenericCollectionType(FacesContext context, Object base, String propertyName) {
        Class<?> beanClass;
        Class<?> genericPropertyClass = null;
        if (base != null && propertyName != null && !Map.class.isAssignableFrom(beanClass = base.getClass()) && !ResourceBundle.class.isAssignableFrom(beanClass)) {
            GenericsIntrospectionCache introspectionCache;
            GenericsIntrospectionCache genericsIntrospectionCache = introspectionCache = GenericsIntrospectionCache.getInstance(context);
            synchronized (genericsIntrospectionCache) {
                GenericsIntrospectionCache.GenericsCacheEntry cacheEntry = introspectionCache.getGenericCacheEntry(beanClass);
                if (cacheEntry.genericPropertiesClasses == null) {
                    cacheEntry.genericPropertiesClasses = new HashMap();
                } else {
                    genericPropertyClass = cacheEntry.genericPropertiesClasses.get(propertyName);
                }
                if (genericPropertyClass == null && !cacheEntry.genericPropertiesClasses.containsKey(propertyName)) {
                    PropertyDescriptor[] descriptors;
                    BeanInfo beanInfo = ELUtils.getBeanInfo(beanClass, cacheEntry);
                    for (PropertyDescriptor pd : descriptors = beanInfo.getPropertyDescriptors()) {
                        if (!propertyName.equals(pd.getName())) continue;
                        Method readMethod = pd.getReadMethod();
                        genericPropertyClass = ELUtils.resolveType(readMethod.getGenericReturnType());
                        break;
                    }
                    cacheEntry.genericPropertiesClasses.put(propertyName, genericPropertyClass);
                }
            }
        }
        return genericPropertyClass;
    }

    public static Class<?> getContainerClass(FacesContext facesContext, ValueExpression expression) {
        CapturingELResolver capturingELResolver;
        ELContext initialELContext = facesContext.getELContext();
        Class<?> type = expression.getType(new ELContextWrapper(initialELContext, capturingELResolver = new CapturingELResolver(initialELContext.getELResolver())));
        Class<?> containerType = type.getComponentType();
        if (containerType == null && type != null && Collection.class.isAssignableFrom(type)) {
            Object base = capturingELResolver.getBase();
            Object property = capturingELResolver.getProperty();
            if (base != null && property != null) {
                containerType = ELUtils.getGenericCollectionType(facesContext, base, property.toString());
            }
        }
        return containerType;
    }
}

