/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ajax4jsf.Messages;
import org.ajax4jsf.cache.Cache;
import org.ajax4jsf.cache.CacheConfigurationLoader;
import org.ajax4jsf.cache.CacheException;
import org.ajax4jsf.cache.CacheFactory;
import org.ajax4jsf.cache.CacheLoader;
import org.ajax4jsf.cache.CacheManager;
import org.ajax4jsf.cache.ServletContextInitMap;
import org.ajax4jsf.resource.CacheContext;
import org.ajax4jsf.resource.CachedResourceContext;
import org.ajax4jsf.resource.FacesResourceContext;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.resource.ResourceLifecycle;
import org.ajax4jsf.resource.ResourceNotFoundException;
import org.ajax4jsf.resource.ServletResourceContext;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.ajax4jsf.webapp.BaseFilter;
import org.ajax4jsf.webapp.CacheContent;
import org.ajax4jsf.webapp.WebXml;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InternetResourceService
implements CacheLoader,
CacheConfigurationLoader {
    private static final Log log = LogFactory.getLog(InternetResourceService.class);
    static final String ENABLE_CACHING_PARAMETER = "enable-cache";
    private static final String RESOURCE_LIFECYCLE_PARAMETER = "org.ajax4jsf.RESOURCE_LIFECYCLE";
    private FilterConfig filterConfig;
    private boolean cacheEnabled = true;
    private Cache cache = null;
    private FacesContextFactory contextFactory;
    private String lifecycleClass;
    private ResourceLifecycle lifecycle;
    private InternetResourceBuilder resourceBuilder;
    private WebXml webXml;

    public void setCacheEnabled(boolean b) {
        this.cacheEnabled = b;
    }

    public void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        ServletContext servletContext = config.getServletContext();
        if ("false".equalsIgnoreCase(config.getInitParameter(ENABLE_CACHING_PARAMETER))) {
            this.setCacheEnabled(false);
        } else {
            try {
                CacheManager cacheManager = CacheManager.getInstance();
                ServletContextInitMap env = new ServletContextInitMap(servletContext);
                CacheFactory cacheFactory = cacheManager.getCacheFactory(env);
                this.cache = cacheFactory.createCache(env, this, this);
            }
            catch (CacheException e) {
                throw new FacesException(e.getMessage(), e);
            }
        }
        this.lifecycleClass = servletContext.getInitParameter(RESOURCE_LIFECYCLE_PARAMETER);
        if (this.lifecycleClass != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clazz = classLoader.loadClass(this.lifecycleClass);
                this.lifecycle = (ResourceLifecycle)clazz.newInstance();
            }
            catch (Exception e) {
                throw new FacesException("Error create instance of resource Lifecycle " + this.lifecycleClass, e);
            }
        } else {
            this.lifecycle = new ResourceLifecycle();
        }
        this.webXml = new WebXml();
        this.webXml.init(servletContext, this.filterConfig.getFilterName());
        if (log.isDebugEnabled()) {
            log.debug("Resources service initialized");
        }
    }

    public boolean serviceResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String resourceKey = this.webXml.getFacesResourceKey(httpServletRequest);
        if (null != resourceKey) {
            this.serviceResource(resourceKey, httpServletRequest, httpServletResponse);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceResource(String resourceKey, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block15: {
            InternetResource resource;
            try {
                resource = this.getResourceBuilder().getResourceForKey(resourceKey);
            }
            catch (ResourceNotFoundException e) {
                throw new ServletException((Throwable)e);
            }
            Object resourceDataForKey = this.getResourceBuilder().getResourceDataForKey(resourceKey);
            ResourceContext resourceContext = this.getResourceContext(resource, request, response);
            resourceContext.setResourceData(resourceDataForKey);
            try {
                if (resource.isCacheable(resourceContext) && this.cacheEnabled) {
                    try {
                        long lastModified;
                        long ifModifiedSince = request.getDateHeader("If-Modified-Since");
                        if (ifModifiedSince >= 0L && (lastModified = resource.getLastModified(resourceContext).getTime() - 1000L) <= ifModifiedSince) {
                            response.setStatus(304);
                            return;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        log.warn(Messages.getMessage("PARSING_IF_MODIFIED_SINCE_WARNING"), e);
                    }
                    String cacheKey = resourceKey;
                    CachedResourceContext cachedResourceContext = new CachedResourceContext(resourceContext);
                    CacheContext cacheLoaderContext = new CacheContext(cachedResourceContext, resource);
                    try {
                        CacheContent content = (CacheContent)this.cache.get(cacheKey, cacheLoaderContext);
                        if (log.isDebugEnabled()) {
                            log.debug(Messages.getMessage("GET_CONTENT_FROM_CACHE_INFO", cacheKey));
                        }
                        content.sendHeaders(response);
                        long expired = resource.getExpired(resourceContext);
                        if (expired < 0L) {
                            expired = 86400000L;
                        }
                        response.setDateHeader("Expires", System.currentTimeMillis() + expired);
                        if (!request.getMethod().equals("HEAD")) {
                            content.send(response);
                        }
                        content.flush(response);
                        break block15;
                    }
                    catch (CacheException e) {
                        log.error(Messages.getMessage("SEND_RESOURCE_ERROR"), e);
                        throw new ServletException(Messages.getMessage("SEND_RESOURCE_ERROR_2", e.getMessage()), (Throwable)e);
                    }
                }
                this.getLifecycle().send(resourceContext, resource);
            }
            finally {
                resourceContext.release();
            }
        }
    }

    protected ResourceContext getResourceContext(InternetResource resource, HttpServletRequest request, HttpServletResponse response) throws FacesException {
        ResourceContext resourceContext;
        FacesContext facesContext = null;
        if (resource.requireFacesContext()) {
            facesContext = this.getFacesContext((ServletRequest)request, (ServletResponse)response);
            resourceContext = new FacesResourceContext(facesContext);
        } else {
            resourceContext = new ServletResourceContext(this.getServletContext(), request, response);
        }
        return resourceContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getProperties(String name) {
        Properties properties = new Properties();
        InputStream props = URLToStreamHelper.urlToStreamSafe(BaseFilter.class.getResource(name));
        if (null != props) {
            try {
                properties.load(props);
            }
            catch (IOException e) {
                log.warn(Messages.getMessage("READING_PROPERTIES_ERROR", name), e);
            }
            finally {
                try {
                    props.close();
                }
                catch (IOException e) {}
            }
        }
        return properties;
    }

    protected ServletContext getServletContext() {
        return this.filterConfig.getServletContext();
    }

    protected ResourceLifecycle getLifecycle() throws FacesException {
        return this.lifecycle;
    }

    protected synchronized FacesContextFactory getContextFactory() {
        if (this.contextFactory == null) {
            this.contextFactory = (FacesContextFactory)FactoryFinder.getFactory("javax.faces.context.FacesContextFactory");
        }
        return this.contextFactory;
    }

    protected FacesContext getFacesContext(ServletRequest request, ServletResponse response) throws FacesException {
        return this.getContextFactory().getFacesContext(this.getServletContext(), request, response, this.getLifecycle());
    }

    protected InternetResourceBuilder getResourceBuilder() {
        if (this.resourceBuilder == null) {
            this.resourceBuilder = InternetResourceBuilder.getInstance();
        }
        return this.resourceBuilder;
    }

    public Object load(Object key, Object context) throws CacheException {
        CacheContext cacheKey = (CacheContext)context;
        CachedResourceContext resourceContext = cacheKey.getResourceContext();
        try {
            this.getLifecycle().send(resourceContext, cacheKey.getResource());
        }
        catch (IOException e) {
            throw new CacheException(e.getMessage(), e);
        }
        return resourceContext.getContent();
    }

    public Properties loadProperties(String name) {
        return this.getProperties(name);
    }
}

