/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.QueueRegistry;
import org.ajax4jsf.component.UIQueue;
import org.ajax4jsf.javascript.AjaxScript;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.ajax4jsf.renderkit.html.QueueRendererData;
import org.ajax4jsf.renderkit.html.scripts.QueueScript;
import org.ajax4jsf.resource.InternetResource;
import org.richfaces.component.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueRenderer
extends HeaderResourcesRendererBase {
    private static final String SIZE_EXCEEDED_BEHAVIOR = "sizeExceededBehavior";
    private static final String SIZE = "size";
    private static final String QUEUE_ONSUBMIT_ATTRIBUTE = "queueonsubmit";
    private static final String QUEUE_ONBEFOREDOMUPDATE_ATTRIBUTE = "queueonbeforedomupdate";
    private static final String QUEUE_ONCOMPLETE_ATTRIBUTE = "queueoncomplete";
    private static final String QUEUE_ONERROR_ATTRIBUTE = "queueonerror";
    public static final String BEHAVIOR_DROP_NEXT = "dropNext";
    public static final String BEHAVIOR_DROP_NEW = "dropNew";
    public static final String BEHAVIOR_FIRE_NEXT = "fireNext";
    public static final String BEHAVIOR_FIRE_NEW = "fireNew";
    private static final String[] REQUEST_ATTRIBUTES = new String[]{"ignoreDupResponses", "requestDelay", "timeout"};
    private InternetResource[] scripts = new InternetResource[]{this.getResource(AjaxScript.class.getName()), this.getResource(QueueScript.class.getName())};
    private static final RendererUtils utils = RendererUtils.getInstance();

    @Override
    protected InternetResource[] getScripts() {
        return this.scripts;
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return UIQueue.class;
    }

    private boolean isValidBehaviorValue(String value) {
        return BEHAVIOR_DROP_NEW.equals(value) || BEHAVIOR_DROP_NEXT.equals(value) || BEHAVIOR_FIRE_NEW.equals(value) || BEHAVIOR_FIRE_NEXT.equals(value);
    }

    private QueueRendererData createRendererData(FacesContext context, UIQueue queue) {
        String onerror;
        String onsubmit;
        String oncomplete;
        String onBeforeDomUpdate;
        String onrequestdequeue;
        String onrequestqueue;
        String onsizeexceeded;
        String sizeExceededBehavior;
        Map<String, Object> attributes = queue.getAttributes();
        QueueRendererData data = new QueueRendererData();
        int size = queue.getSize();
        if (utils.shouldRenderAttribute(size)) {
            data.addQueueAttribute(SIZE, size);
        }
        if (utils.shouldRenderAttribute(sizeExceededBehavior = (String)attributes.get(SIZE_EXCEEDED_BEHAVIOR))) {
            if (!this.isValidBehaviorValue(sizeExceededBehavior)) {
                throw new IllegalArgumentException(sizeExceededBehavior + " value of " + SIZE_EXCEEDED_BEHAVIOR + " attribute is not a legal one for component: " + MessageUtil.getLabel((FacesContext)context, (UIComponent)queue));
            }
            data.addQueueAttribute(SIZE_EXCEEDED_BEHAVIOR, sizeExceededBehavior);
        }
        if (utils.shouldRenderAttribute(onsizeexceeded = queue.getOnsizeexceeded())) {
            data.addQueueAttribute("onsizeexceeded", new JSFunctionDefinition("query", "options", "event").addToBody(onsizeexceeded));
        }
        if (utils.shouldRenderAttribute(onrequestqueue = queue.getOnrequestqueue())) {
            data.addQueueAttribute("onrequestqueue", new JSFunctionDefinition("query", "options", "event").addToBody(onrequestqueue));
        }
        if (utils.shouldRenderAttribute(onrequestdequeue = queue.getOnrequestdequeue())) {
            data.addQueueAttribute("onrequestdequeue", new JSFunctionDefinition("query", "options", "event").addToBody(onrequestdequeue));
        }
        for (String attributeName : REQUEST_ATTRIBUTES) {
            Object value = attributes.get(attributeName);
            if (!utils.shouldRenderAttribute(value)) continue;
            data.addRequestAttribute(attributeName, value);
        }
        String status = AjaxRendererUtils.getAjaxStatus(queue);
        if (utils.shouldRenderAttribute(status)) {
            data.addRequestAttribute("status", status);
        }
        if (utils.shouldRenderAttribute(onBeforeDomUpdate = queue.getOnbeforedomupdate())) {
            data.addRequestAttribute(QUEUE_ONBEFOREDOMUPDATE_ATTRIBUTE, AjaxRendererUtils.buildAjaxOnBeforeDomUpdate(onBeforeDomUpdate));
        }
        if (utils.shouldRenderAttribute(oncomplete = queue.getOncomplete())) {
            data.addRequestAttribute(QUEUE_ONCOMPLETE_ATTRIBUTE, AjaxRendererUtils.buildAjaxOncomplete(oncomplete));
        }
        if (utils.shouldRenderAttribute(onsubmit = queue.getOnsubmit())) {
            JSFunctionDefinition onsubmitFunction = new JSFunctionDefinition("request");
            onsubmitFunction.addToBody(onsubmit);
            data.addRequestAttribute(QUEUE_ONSUBMIT_ATTRIBUTE, onsubmitFunction);
        }
        if (utils.shouldRenderAttribute(onerror = queue.getOnerror())) {
            JSFunctionDefinition onerrorFunction = new JSFunctionDefinition("request", "status", "message");
            onerrorFunction.addToBody(onerror);
            data.addRequestAttribute(QUEUE_ONERROR_ATTRIBUTE, onerrorFunction);
        }
        return data;
    }

    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component);
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        UIQueue queue = (UIQueue)component;
        if (!queue.isDisabled()) {
            QueueRegistry.getInstance(context).registerQueue(context, queue.getClientName(context), this.createRendererData(context, queue));
        }
    }
}

