/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit.compiler;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.el.MethodNotFoundException;
import org.ajax4jsf.Messages;
import org.ajax4jsf.renderkit.compiler.InvokeData;
import org.ajax4jsf.renderkit.compiler.Invoker;
import org.ajax4jsf.renderkit.compiler.MethodCacheState;
import org.ajax4jsf.renderkit.compiler.MethodCallElement;
import org.ajax4jsf.renderkit.compiler.TemplateContext;

class StaticInvoker
extends Invoker {
    String className;
    Class cls;
    Map methods = new HashMap();

    StaticInvoker(String methodName) {
        this.methodName = methodName;
        int i = methodName.lastIndexOf(46);
        this.className = methodName.substring(0, i);
        this.methodName = methodName.substring(i + 1);
        try {
            this.cls = Thread.currentThread().getContextClassLoader().loadClass(this.className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    InvokeData invokeMethod(TemplateContext context, MethodCacheState state) {
        if (this.cls == null) {
            throw new FacesException(this.className, new ClassNotFoundException(this.className));
        }
        return this.invokeMethod(context, this.methods, this.cls, null, state);
    }

    void handleInvocationTargetException(TemplateContext context, InvocationTargetException e) {
        MethodCallElement._log.error(Messages.getMessage("METHOD_CALL_ERROR_1a", this.methodName, context.getComponent().getId()), e);
        throw new FacesException(Messages.getMessage("METHOD_CALL_ERROR_2a", new Object[]{this.methodName, context.getComponent().getId(), e.getCause().getMessage()}), e);
    }

    void handleIllegalAccessException(TemplateContext context, IllegalAccessException e) {
        MethodCallElement._log.error(Messages.getMessage("METHOD_CALL_ERROR_3a", this.methodName, context.getComponent().getId()), e);
        throw new FacesException(Messages.getMessage("METHOD_CALL_ERROR_4a", new Object[]{this.methodName, context.getComponent().getId(), e.getCause().getMessage()}), e);
    }

    void handleMethodNotFoundException(TemplateContext context) throws MethodNotFoundException {
        MethodCallElement._log.error(Messages.getMessage("METHOD_CALL_ERROR_5a", this.methodName, context.getComponent().getId()));
        throw new MethodNotFoundException(Messages.getMessage("METHOD_CALL_ERROR_6a", this.methodName));
    }
}

