/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit.compiler;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.el.MethodNotFoundException;
import org.ajax4jsf.Messages;
import org.ajax4jsf.renderkit.compiler.InvokeData;
import org.ajax4jsf.renderkit.compiler.Invoker;
import org.ajax4jsf.renderkit.compiler.MethodCacheState;
import org.ajax4jsf.renderkit.compiler.MethodCallElement;
import org.ajax4jsf.renderkit.compiler.TemplateContext;

class RendererInvoker
extends Invoker {
    boolean utils = false;
    Map renderers = new HashMap();

    public RendererInvoker(boolean utils, String methodName) {
        this.utils = utils;
        this.methodName = methodName;
    }

    public Class getInvokedClass(TemplateContext context) {
        Object object = this.getInvokedObject(context);
        return object != null ? object.getClass() : null;
    }

    private Object getInvokedObject(TemplateContext context) {
        if (this.utils) {
            return context.getRenderer().getUtils();
        }
        return context.getRenderer();
    }

    InvokeData invokeMethod(TemplateContext context, MethodCacheState state) {
        Object object = this.getInvokedObject(context);
        Map methods = this.getMethods(object);
        return this.invokeMethod(context, methods, null, object, state);
    }

    private Map getMethods(Object object) {
        if (object == null) {
            return null;
        }
        HashMap methods = (HashMap)this.renderers.get(object);
        if (methods == null) {
            methods = new HashMap();
            this.renderers.put(object, methods);
        }
        return methods;
    }

    void handleInvocationTargetException(TemplateContext context, InvocationTargetException e) {
        String logMessage = this.utils ? Messages.getMessage("METHOD_CALL_ERROR_1", this.methodName, context.getComponent().getId()) : Messages.getMessage("METHOD_CALL_ERROR_1a", this.methodName, context.getComponent().getId());
        String excMessage = this.utils ? Messages.getMessage("METHOD_CALL_ERROR_2", new Object[]{this.methodName, context.getComponent().getId(), e.getCause().getMessage()}) : Messages.getMessage("METHOD_CALL_ERROR_2a", new Object[]{this.methodName, context.getComponent().getId(), e.getCause().getMessage()});
        MethodCallElement._log.error(logMessage, e);
        throw new FacesException(excMessage, e);
    }

    void handleIllegalAccessException(TemplateContext context, IllegalAccessException e) {
        String logMessage = this.utils ? Messages.getMessage(Messages.getMessage("METHOD_CALL_ERROR_3", this.methodName, context.getComponent().getId())) : Messages.getMessage(Messages.getMessage("METHOD_CALL_ERROR_3a", this.methodName, context.getComponent().getId()));
        String excMessage = this.utils ? Messages.getMessage(Messages.getMessage("METHOD_CALL_ERROR_4", new Object[]{this.methodName, context.getComponent().getId(), e.getCause().getMessage()})) : Messages.getMessage(Messages.getMessage("METHOD_CALL_ERROR_4a", new Object[]{this.methodName, context.getComponent().getId(), e.getCause().getMessage()}));
        MethodCallElement._log.error(logMessage, e);
        throw new FacesException(excMessage, e);
    }

    void handleMethodNotFoundException(TemplateContext context) throws MethodNotFoundException {
        String logMessage = this.utils ? Messages.getMessage(Messages.getMessage("METHOD_CALL_ERROR_5", this.methodName, context.getComponent().getId())) : Messages.getMessage(Messages.getMessage("METHOD_CALL_ERROR_5a", this.methodName, context.getComponent().getId()));
        String excMessage = this.utils ? Messages.getMessage(Messages.getMessage("METHOD_CALL_ERROR_6", this.methodName)) : Messages.getMessage(Messages.getMessage("METHOD_CALL_ERROR_6a", this.methodName));
        MethodCallElement._log.error(logMessage);
        throw new FacesException(excMessage);
    }
}

