/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit;

import java.util.Iterator;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.ajax4jsf.Messages;
import org.ajax4jsf.renderkit.ChameleonRenderKit;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChameleonRenderKitFactory
extends RenderKitFactory {
    RenderKitFactory defaultFactory;
    private static final Log _log = LogFactory.getLog(ChameleonRenderKitFactory.class);

    public ChameleonRenderKitFactory(RenderKitFactory defaultFactory) {
        if (_log.isDebugEnabled()) {
            _log.debug("ChameleonRenderKitFactory(RenderKitFactory) - Chameleon RenderKit factory instantiated");
        }
        this.defaultFactory = defaultFactory;
        InternetResourceBuilder.getInstance().init();
    }

    @Override
    public void addRenderKit(String renderKitId, RenderKit renderKit) {
        if (_log.isDebugEnabled()) {
            _log.debug("addRenderKit(String, RenderKit) - Added RenderKit with id - renderKitId=" + renderKitId);
        }
        if (renderKit instanceof ChameleonRenderKit) {
            // empty if block
        }
        this.defaultFactory.addRenderKit(renderKitId, renderKit);
    }

    @Override
    public RenderKit getRenderKit(FacesContext context, String renderKitId) {
        RenderKit renderKit = this.defaultFactory.getRenderKit(context, renderKitId);
        if (renderKit instanceof ChameleonRenderKit) {
            if (_log.isDebugEnabled()) {
                _log.debug(Messages.getMessage("REQUEST_CHAMELEON_RENDER_KIT_INFO", renderKitId));
            }
            String baseRenderKitId = null;
            try {
                if (null != context) {
                    baseRenderKitId = context.getApplication().getDefaultRenderKitId();
                } else {
                    ApplicationFactory appFactory = (ApplicationFactory)FactoryFinder.getFactory("javax.faces.application.ApplicationFactory");
                    baseRenderKitId = appFactory.getApplication().getDefaultRenderKitId();
                }
            }
            catch (Exception e) {
                _log.warn(Messages.getMessage("GET_DEFAULT_RENDER_KIT_ERROR"), e);
            }
            if (baseRenderKitId == null) {
                baseRenderKitId = "HTML_BASIC";
            }
            if (_log.isDebugEnabled()) {
                _log.debug(Messages.getMessage("DEFAULT_RENDER_KIT_INFO", baseRenderKitId));
            }
            ((ChameleonRenderKit)((Object)renderKit)).setDefaultRenderKit(this.defaultFactory.getRenderKit(context, baseRenderKitId));
        }
        return renderKit;
    }

    @Override
    public Iterator<String> getRenderKitIds() {
        return this.defaultFactory.getRenderKitIds();
    }
}

