/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.org.w3c.tidy;

import java.io.IOException;
import java.io.InputStream;
import org.ajax4jsf.org.w3c.tidy.Configuration;
import org.ajax4jsf.org.w3c.tidy.EncodingUtils;
import org.ajax4jsf.org.w3c.tidy.Lexer;
import org.ajax4jsf.org.w3c.tidy.StreamIn;
import org.ajax4jsf.org.w3c.tidy.TidyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamInImpl
implements StreamIn {
    private static final Log log = LogFactory.getLog(StreamInImpl.class);
    private static final int CHARBUF_SIZE = 5;
    private Lexer lexer;
    private int[] charbuf = new int[5];
    private int bufpos;
    private char[] rawBytebuf = new char[5];
    private int rawBufpos;
    private boolean rawPushed;
    private boolean lookingForBOM = true;
    private boolean endOfStream;
    private boolean pushed;
    private int tabs;
    private int tabsize;
    private int state;
    private int encoding;
    private int curcol;
    private int lastcol;
    private int curline;
    private InputStream stream;
    private EncodingUtils.GetBytes getBytes;
    private boolean rawOut;
    private byte[] bytes = new byte[256];
    private int index = 0;
    private int length = 0;

    public StreamInImpl(InputStream stream, Configuration configuration) {
        this.stream = stream;
        this.charbuf[0] = 0;
        this.tabsize = configuration.tabsize;
        this.curline = 1;
        this.curcol = 1;
        this.encoding = configuration.getInCharEncoding();
        this.rawOut = configuration.rawOut;
        this.state = 0;
        this.getBytes = new EncodingUtils.GetBytes(){
            StreamInImpl in;

            EncodingUtils.GetBytes setStreamIn(StreamInImpl in) {
                this.in = in;
                return this;
            }

            public void doGet(int[] buf, int[] count, boolean unget) {
                this.in.readRawBytesFromStream(buf, count, unget);
            }
        }.setStreamIn(this);
    }

    public int getCurcol() {
        return this.curcol;
    }

    public int getCurline() {
        return this.curline;
    }

    public void setLexer(Lexer lexer) {
        this.lexer = lexer;
    }

    public int readChar() {
        int c;
        block29: {
            if (this.pushed) {
                int c2 = this.charbuf[--this.bufpos];
                if (this.bufpos == 0) {
                    this.pushed = false;
                }
                if (c2 == 10) {
                    this.curcol = 1;
                    ++this.curline;
                } else {
                    ++this.curcol;
                }
                return c2;
            }
            this.lastcol = this.curcol++;
            if (this.tabs > 0) {
                --this.tabs;
                return 32;
            }
            while (true) {
                if ((c = this.readCharFromStream()) < 0) {
                    return -1;
                }
                if (c == 10) {
                    this.curcol = 1;
                    ++this.curline;
                    break block29;
                }
                if (c == 13) {
                    c = this.readCharFromStream();
                    if (c != 10) {
                        if (c != -1) {
                            this.ungetChar(c);
                        }
                        c = 10;
                    }
                    this.curcol = 1;
                    ++this.curline;
                    break block29;
                }
                if (c == 9) {
                    this.tabs = this.tabsize - (this.curcol - 1) % this.tabsize - 1;
                    ++this.curcol;
                    c = 32;
                    break block29;
                }
                if (c == 27 || c == 13 && !this.lexer.configuration.xmlTags) break block29;
                if (0 < c && c < 32) continue;
                if (this.rawOut || this.encoding == 4 || this.encoding == 3 || this.encoding == 11 || this.encoding == 10) {
                    ++this.curcol;
                    break block29;
                }
                if (this.encoding == 6 || this.encoding == 8 || this.encoding == 7) {
                    if (c > 0x10FFFF) {
                        this.lexer.report.encodingError(this.lexer, 79, c);
                        c = 0;
                    } else if (c >= 55296 && c <= 56319) {
                        int n = c;
                        int m = this.readCharFromStream();
                        if (m < 0) {
                            return -1;
                        }
                        if (m >= 56320 && m <= 57343) {
                            c = (n - 55296) * 1024 + (m - 56320) + 65536;
                            if ((c & 0xFFFE) == 65534 || (c & 0xFFFF) == 65535 || c < 65536) {
                                this.lexer.report.encodingError(this.lexer, 79, c);
                                c = 0;
                            }
                        } else {
                            this.lexer.report.encodingError(this.lexer, 79, c);
                            c = 0;
                        }
                    }
                }
                if (this.encoding == 5) {
                    c = EncodingUtils.decodeMacRoman(c);
                }
                if (127 < c && c < 160) {
                    int replaceMode;
                    int c1 = 0;
                    this.lexer.lines = this.curline;
                    this.lexer.columns = this.curcol;
                    if (this.encoding == 9 || this.lexer.configuration.replacementCharEncoding == 9) {
                        c1 = EncodingUtils.decodeWin1252(c);
                    } else if (this.lexer.configuration.replacementCharEncoding == 5) {
                        c1 = EncodingUtils.decodeMacRoman(c);
                    }
                    int n = replaceMode = TidyUtils.toBoolean(c1) ? 0 : 1;
                    if (c1 == 0 && this.encoding == 9 || this.encoding == 5) {
                        this.lexer.report.encodingError(this.lexer, 0x4C | replaceMode, c);
                    } else if (this.encoding != 9 && this.encoding != 5) {
                        this.lexer.report.encodingError(this.lexer, 0x4D | replaceMode, c);
                    }
                    c = c1;
                }
                if (c != 0) break;
            }
            ++this.curcol;
        }
        return c;
    }

    public void ungetChar(int c) {
        this.pushed = true;
        if (this.bufpos >= 5) {
            System.arraycopy(this.charbuf, 0, this.charbuf, 1, 4);
            --this.bufpos;
        }
        this.charbuf[this.bufpos++] = c;
        if (c == 10) {
            --this.curline;
        }
        this.curcol = this.lastcol;
    }

    public boolean isEndOfStream() {
        return this.endOfStream;
    }

    public int readCharFromStream() {
        int c1;
        int[] n = new int[]{0};
        int[] tempchar = new int[1];
        int[] count = new int[]{1};
        this.readRawBytesFromStream(tempchar, count, false);
        if (count[0] <= 0) {
            this.endOfStream = true;
            return -1;
        }
        int c = tempchar[0];
        if (this.lookingForBOM && (this.encoding == 8 || this.encoding == 6 || this.encoding == 7 || this.encoding == 3)) {
            this.lookingForBOM = false;
            if (c == -1) {
                this.lookingForBOM = false;
                this.endOfStream = true;
                return -1;
            }
            count[0] = 1;
            this.readRawBytesFromStream(tempchar, count, false);
            c1 = tempchar[0];
            int bom = (c << 8) + c1;
            if (bom == 65279) {
                if (this.encoding != 8 && this.encoding != 7) {
                    this.lexer.report.encodingError(this.lexer, 80, 7);
                }
                this.encoding = 7;
                this.lexer.configuration.setInCharEncoding(7);
                return 65279;
            }
            if (bom == 65534) {
                if (this.encoding != 8 && this.encoding != 6) {
                    this.lexer.report.encodingError(this.lexer, 80, 6);
                }
                this.encoding = 6;
                this.lexer.configuration.setInCharEncoding(6);
                return 65279;
            }
            count[0] = 1;
            this.readRawBytesFromStream(tempchar, count, false);
            int c2 = tempchar[0];
            if ((c << 16) + (c1 << 8) + c2 == 0xEFBBBF) {
                this.encoding = 3;
                if (this.encoding != 3) {
                    this.lexer.report.encodingError(this.lexer, 80, 3);
                }
                this.lexer.configuration.setInCharEncoding(3);
                return 65279;
            }
            this.rawPushed = true;
            if (this.rawBufpos + 1 >= 5) {
                System.arraycopy(this.rawBytebuf, 2, this.rawBytebuf, 0, 3);
                this.rawBufpos -= 2;
            }
            this.rawBytebuf[this.rawBufpos++] = (char)c2;
            this.rawBytebuf[this.rawBufpos++] = (char)c1;
        }
        this.lookingForBOM = false;
        if (this.encoding == 4) {
            if (c == 27) {
                this.state = 1;
                return c;
            }
            switch (this.state) {
                case 1: {
                    if (c == 36) {
                        this.state = 2;
                        break;
                    }
                    if (c == 40) {
                        this.state = 4;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 2: {
                    if (c == 40) {
                        this.state = 3;
                        break;
                    }
                    this.state = 5;
                    break;
                }
                case 3: {
                    this.state = 5;
                    break;
                }
                case 4: {
                    this.state = 0;
                    break;
                }
                case 5: {
                    c |= 0x80;
                    break;
                }
            }
            return c;
        }
        if (this.encoding == 6) {
            count[0] = 1;
            this.readRawBytesFromStream(tempchar, count, false);
            if (count[0] <= 0) {
                this.endOfStream = true;
                return -1;
            }
            c1 = tempchar[0];
            n[0] = (c1 << 8) + c;
            return n[0];
        }
        if (this.encoding == 8 || this.encoding == 7) {
            count[0] = 1;
            this.readRawBytesFromStream(tempchar, count, false);
            if (count[0] <= 0) {
                this.endOfStream = true;
                return -1;
            }
            c1 = tempchar[0];
            n[0] = (c << 8) + c1;
            return n[0];
        }
        if (this.encoding == 3) {
            int[] count2 = new int[]{0};
            boolean err = EncodingUtils.decodeUTF8BytesToChar(n, c, new byte[0], this.getBytes, count2, 0);
            if (!err && n[0] == -1 && count2[0] == 1) {
                this.endOfStream = true;
                return -1;
            }
            if (err) {
                this.lexer.lines = this.curline;
                this.lexer.columns = this.curcol;
                this.lexer.report.encodingError(this.lexer, 78, n[0]);
                n[0] = 65533;
            }
            return n[0];
        }
        if (this.encoding == 10 || this.encoding == 11) {
            if (c < 128) {
                return c;
            }
            if (this.encoding == 11 && c >= 161 && c <= 223) {
                return c;
            }
            count[0] = 1;
            this.readRawBytesFromStream(tempchar, count, false);
            if (count[0] <= 0) {
                this.endOfStream = true;
                return -1;
            }
            c1 = tempchar[0];
            n[0] = (c << 8) + c1;
            return n[0];
        }
        n[0] = c;
        return n[0];
    }

    protected void readRawBytesFromStream(int[] buf, int[] count, boolean unget) {
        try {
            for (int i = 0; i < count[0]; ++i) {
                int c;
                if (unget) {
                    c = this.readByteFromStreamBuffer();
                    if (c == -1) {
                        count[0] = -i;
                        return;
                    }
                    this.rawPushed = true;
                    if (this.rawBufpos >= 5) {
                        System.arraycopy(this.rawBytebuf, 1, this.rawBytebuf, 0, 4);
                        --this.rawBufpos;
                    }
                    this.rawBytebuf[this.rawBufpos++] = (char)buf[i];
                    continue;
                }
                if (this.rawPushed) {
                    buf[i] = this.rawBytebuf[--this.rawBufpos];
                    if (this.rawBufpos != 0) continue;
                    this.rawPushed = false;
                    continue;
                }
                c = this.readByteFromStreamBuffer();
                if (c == -1) {
                    count[0] = -i;
                    break;
                }
                buf[i] = (char)c;
            }
        }
        catch (IOException e) {
            log.error("StreamInImpl.readRawBytesFromStream: " + e.toString());
        }
    }

    private int readByteFromStreamBuffer() throws IOException {
        if (this.index >= this.length) {
            if (this.length < 0) {
                return -1;
            }
            this.length = this.stream.read(this.bytes);
            this.index = 0;
        }
        if (this.index < this.length) {
            int c = this.bytes[this.index];
            if (c < 0) {
                c += 256;
            }
            ++this.index;
            return c;
        }
        return -1;
    }
}

