/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.event;

import java.util.Map;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.ajax4jsf.Messages;
import org.ajax4jsf.context.AjaxContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.skin.SkinFactory;

public class AjaxPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = -4087936963051339868L;
    public static final String VIEW_BEAN_PREFIX = "org.ajax4jsf.viewbean:";
    private static final Log log = LogFactory.getLog(AjaxPhaseListener.class);
    public static final String AJAX_BEAN_PREFIX = "org.ajax4jsf.ajaxviewbean:";

    public void afterPhase(PhaseEvent event) {
        UIViewRoot viewRoot;
        PhaseId phaseId = event.getPhaseId();
        if (log.isDebugEnabled()) {
            log.debug("Process after phase " + phaseId.toString());
        }
        FacesContext context = event.getFacesContext();
        Map<String, Object> requestMap = context.getExternalContext().getRequestMap();
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance(context);
        if (phaseId == PhaseId.RESTORE_VIEW && null != (viewRoot = context.getViewRoot())) {
            boolean isAjax = ajaxContext.isAjaxRequest();
            Map<String, Object> attributes = viewRoot.getAttributes();
            for (String stringKey : attributes.keySet()) {
                if (stringKey.startsWith(VIEW_BEAN_PREFIX)) {
                    requestMap.put(stringKey.substring(VIEW_BEAN_PREFIX.length()), attributes.get(stringKey));
                    continue;
                }
                if (!isAjax || !stringKey.startsWith(AJAX_BEAN_PREFIX)) continue;
                requestMap.put(stringKey.substring(AJAX_BEAN_PREFIX.length()), attributes.get(stringKey));
            }
        }
    }

    public void beforePhase(PhaseEvent event) {
        PhaseId phaseId = event.getPhaseId();
        if (log.isDebugEnabled()) {
            log.debug("Process before phase " + phaseId.toString());
        }
        FacesContext context = event.getFacesContext();
        if (phaseId == PhaseId.RENDER_RESPONSE) {
            AjaxContext.getCurrentInstance(context).setViewIdHolder(null);
            UIViewRoot root = context.getViewRoot();
            if (null != root) {
                log.debug(Messages.getMessage("ENTER_BEFORE_RENDER_VIEW_PHASE", root.getViewId(), root.getRenderKitId()));
                String renderKitId = null;
                try {
                    renderKitId = SkinFactory.getInstance().getSkin(context).getRenderKitId(context);
                }
                catch (Exception e) {
                    log.error("Exception on get current Skin ", e);
                }
                if (null != renderKitId) {
                    log.debug(Messages.getMessage("SET_RENDER_KIT_ID_INFO", renderKitId));
                    root.setRenderKitId(renderKitId);
                }
            }
        } else if (phaseId == PhaseId.RESTORE_VIEW) {
            // empty if block
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

