/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.component;

import java.io.IOException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.ajax4jsf.Messages;
import org.ajax4jsf.component.AjaxLoadBundleComponent;
import org.ajax4jsf.component.ResourceBundleMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UILoadBundle
extends UIComponentBase
implements AjaxLoadBundleComponent {
    public static final String COMPONENT_FAMILY = "org.ajax4jsf.Bundle";
    public static final String COMPONENT_TYPE = "org.ajax4jsf.Bundle";
    private static final Log _log = LogFactory.getLog(UILoadBundle.class);

    public String getFamily() {
        return "org.ajax4jsf.Bundle";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.loadBundle(context);
    }

    public void decode(FacesContext context) {
        this.loadBundle(context);
    }

    public void loadBundle(FacesContext context) {
        ResourceBundle bundle;
        UIViewRoot viewRoot = context.getViewRoot();
        Locale locale = viewRoot.getLocale();
        if (locale == null) {
            locale = context.getApplication().getDefaultLocale();
        }
        try {
            bundle = ResourceBundle.getBundle(this.getBasename(), locale, Thread.currentThread().getContextClassLoader());
        }
        catch (MissingResourceException e) {
            _log.error(Messages.getMessage("COULD_NOT_LOAD_RESOURCE_BUNDLE", this.getBasename()));
            return;
        }
        context.getExternalContext().getRequestMap().put(this.getVar(), new ResourceBundleMap(bundle));
    }

    public String getRendererType() {
        return null;
    }

    public abstract String getBasename();

    public abstract void setBasename(String var1);

    public abstract String getVar();

    public abstract void setVar(String var1);
}

