/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.component;

import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.ajax4jsf.component.AjaxComponent;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.event.AjaxListener;
import org.ajax4jsf.event.AjaxSource;
import org.ajax4jsf.renderkit.RendererUtils;

public abstract class AjaxActionComponent
extends UICommand
implements AjaxComponent,
AjaxSource {
    public static final String FOCUS_DATA_ID = "_A4J.AJAX.focus";

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof AjaxEvent) {
            String focus;
            FacesContext context = this.getFacesContext();
            this.setupReRender(context);
            Object data = this.getData();
            AjaxContext ajaxContext = AjaxContext.getCurrentInstance(context);
            if (null != data) {
                ajaxContext.setResponseData(data);
            }
            if (null != (focus = this.getFocus())) {
                UIComponent focusComponent = RendererUtils.getInstance().findComponentFor(this, focus);
                if (null != focusComponent) {
                    focus = focusComponent.getClientId(context);
                }
                ajaxContext.getResponseDataMap().put(FOCUS_DATA_ID, focus);
            }
            ajaxContext.setOncomplete(this.getOncomplete());
        }
    }

    protected void setupReRender() {
    }

    protected void setupReRender(FacesContext facesContext) {
        AjaxContext.getCurrentInstance(facesContext).addRegionsFromComponent(this);
        this.setupReRender();
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof ActionEvent) {
            if (event.getComponent() == this) {
                if (this.isImmediate()) {
                    event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
                } else if (this.isBypassUpdates()) {
                    event.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
                } else {
                    event.setPhaseId(PhaseId.INVOKE_APPLICATION);
                }
            }
            this.getParent().queueEvent(event);
        } else {
            super.queueEvent(event);
        }
    }

    public void addAjaxListener(AjaxListener listener) {
        this.addFacesListener(listener);
    }

    public AjaxListener[] getAjaxListeners() {
        AjaxListener[] al = (AjaxListener[])this.getFacesListeners(AjaxListener.class);
        return al;
    }

    public void removeAjaxListener(AjaxListener listener) {
        this.removeFacesListener(listener);
    }

    protected UIComponent getSingleComponent() {
        return this;
    }
}

