/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.component.behavior;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.Application;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHint;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;

public class AjaxBehaviors
implements Serializable {
    private static final String AJAX_BEHAVIORS = "javax.faces.component.AjaxBehaviors";
    private LinkedList<BehaviorInfo> behaviorStack = new LinkedList();

    public static AjaxBehaviors getAjaxBehaviors(FacesContext context, boolean createIfNull) {
        Map<Object, Object> attrs = context.getAttributes();
        AjaxBehaviors ajaxBehaviors = (AjaxBehaviors)attrs.get(AJAX_BEHAVIORS);
        if (ajaxBehaviors == null && createIfNull) {
            ajaxBehaviors = new AjaxBehaviors();
            attrs.put(AJAX_BEHAVIORS, ajaxBehaviors);
        }
        return ajaxBehaviors;
    }

    public void addBehaviors(FacesContext context, ClientBehaviorHolder behaviorHolder) {
        if (this.behaviorStack == null || this.behaviorStack.isEmpty()) {
            return;
        }
        int count = this.behaviorStack.size();
        for (int i = count - 1; i >= 0; --i) {
            this.behaviorStack.get(i).addBehavior(context, behaviorHolder);
        }
    }

    public void pushBehavior(FacesContext context, AjaxBehavior ajaxBehavior, String eventName) {
        this.behaviorStack.add(new BehaviorInfo(context, ajaxBehavior, eventName));
    }

    public void popBehavior() {
        if (this.behaviorStack.size() > 0) {
            this.behaviorStack.removeLast();
        }
    }

    public static class BehaviorInfo {
        private String eventName;
        private Object behaviorState;

        public BehaviorInfo(FacesContext context, AjaxBehavior ajaxBehavior, String eventName) {
            this.eventName = eventName;
            this.behaviorState = ajaxBehavior.saveState(context);
        }

        public void addBehavior(FacesContext context, ClientBehaviorHolder behaviorHolder) {
            String eventName = this.eventName;
            if (eventName == null && (eventName = behaviorHolder.getDefaultEventName()) == null) {
                return;
            }
            if (this.shouldAddBehavior(behaviorHolder, eventName)) {
                ClientBehavior behavior = this.createBehavior(context);
                behaviorHolder.addClientBehavior(eventName, behavior);
            }
        }

        private boolean shouldAddBehavior(ClientBehaviorHolder behaviorHolder, String eventName) {
            if (!behaviorHolder.getEventNames().contains(eventName)) {
                return false;
            }
            Map<String, List<ClientBehavior>> allBehaviors = behaviorHolder.getClientBehaviors();
            List<ClientBehavior> eventBehaviors = allBehaviors.get(eventName);
            if (eventBehaviors == null || eventBehaviors.isEmpty()) {
                return true;
            }
            for (ClientBehavior behavior : eventBehaviors) {
                Set<ClientBehaviorHint> hints = behavior.getHints();
                if (!hints.contains((Object)ClientBehaviorHint.SUBMITTING)) continue;
                return false;
            }
            return true;
        }

        private ClientBehavior createBehavior(FacesContext context) {
            Application application = context.getApplication();
            AjaxBehavior behavior = (AjaxBehavior)application.createBehavior("javax.faces.behavior.Ajax");
            behavior.restoreState(context, this.behaviorState);
            return behavior;
        }

        private BehaviorInfo() {
        }
    }
}

