import os
from collections import defaultdict
import importlib

import logging
l = logging.getLogger("rex.exploit.techniques")

from ..technique import Technique

from .rop_set_register import RopSetRegister
from .shellcode_set_register import ShellcodeSetRegister
from .circumstantial_set_register import CircumstantialSetRegister
from .rop_leak_memory import RopLeakMemory
from .shellcode_leak_address import ShellcodeLeakAddress
from .rop_to_system import RopToSystem
from .rop_to_execl import RopToExecl
from .call_shellcode import CallShellcode
from .call_jmp_sp_shellcode import CallJmpSPShellcode
from .explore_for_exploit import ExploreForExploit
from .rop_register_control import RopRegisterControl
from .rop_to_execl import RopToExecl
from .rop_to_accept_system import RopToAcceptSystem
from .rop_to_system_complicated import RopToSystemComplicated
from .ret2libc import Ret2Libc
#from .stager import Stager

Techniques = defaultdict(list)
for t in Technique.__subclasses__():
    for o in t.applicable_to:
        Techniques[o].append(t)

Techniques = dict(Techniques)
