
from archinfo import Endness

from .utils import convert_arch


class NopSleds:

    @staticmethod
    def get_nopsleds(arch):

        arch = convert_arch(arch)

        if arch.name == "X86":
            return [b"\x90"]  # nop
        elif arch.name == "AMD64":
            return [b"\x90"]  # nop
        elif arch.name == "ARM":
            return [b'\x00\xf0\x20\xe3']  # nop
        elif arch.name == "MIPS32":
            sleds_le = [b"\x26\x78\xe0\x01"] # xor $t7, $t7, $zero
            if arch.memory_endness == Endness.LE:
                return sleds_le
            elif arch.memory_endness == Endness.BE:
                return [ chunk[::-1] for chunk in sleds_le ]
        else:
            raise NotImplementedError("get_nopsleds: Unsupported architecture %s." % arch.name)
