from rex.exploit.cgc import CGCType2Exploit

class CGCType2RopExploit(CGCType2Exploit):
    '''
    A CGC type2 exploit object, which leaks memory at an address using rop.
    '''

    def __init__(self, crash, ch_sym_mem, address_var, length_var):
        '''
        :param crash: a crash object which has been modified to exploit a vulnerability
        :param ch_sym_mem: symbolic memory where chain will exist
        :param address_var: the claripy variable representing the address to leak
        :param length_var: the claripy variable representing the length of
        the leak
        '''
        super(CGCType2RopExploit, self).__init__(crash, bypasses_nx=True, bypasses_aslr=True)

        self.method_name = 'rop'

        self._mem = ch_sym_mem
        self._arg_vars = [address_var, length_var]

        self._address_var_idx = len(self._mem.variables) + 2
        self._length_var_idx = len(self._mem.variables) + 3

        st = self.crash.state
        self._output_leak_idx = st.solver.eval(st.posix.fd[1].write_pos)

        self._generate_formula()

    def __str__(self):
        return "rop type2"
