import { AvailableFunction } from ".";
export declare enum TokenType {
    IDENTIFIER = 0,
    WILDCARD = 1,
    DESCENDANT = 2,
    CHILD = 3,
    PARENT = 4,
    AND = 5,
    OR = 6,
    EQUALS = 7,
    LITERAL = 8,
    ATTRIBUTESELECTOR = 9,
    RESOLVESELECTOR = 10,
    BINDINGSELECTOR = 11,
    FILTERBEGIN = 12,
    FILTEREND = 13,
    SEPARATOR = 14,
    PARAMETERSBEGIN = 15,
    PARAMETERSEND = 16,
    FUNCTION = 17
}
export declare const NodeType: {
    readonly PARENT: 241;
    readonly CHILD: 242;
    readonly DESCENDANT: 243;
    readonly AND: 244;
    readonly OR: 245;
    readonly EQUALS: 246;
    readonly LITERAL: 247;
    readonly FUNCTION: 248;
};
type Token = {
    tokenType: TokenType;
    value?: string;
};
export declare function tokenize(input: string): Token[];
type BaseNode = {
    attribute?: boolean;
    binding?: boolean;
    resolve?: boolean;
    filter?: QNode;
    value?: string;
    child?: QNode;
};
export type Selector = BaseNode & ({
    type: typeof NodeType.CHILD | typeof NodeType.DESCENDANT;
    attribute: boolean;
    binding: boolean;
    value: string;
    resolve: boolean;
} | {
    type: typeof NodeType.PARENT;
});
export type Condition = BaseNode & {
    type: typeof NodeType.AND | typeof NodeType.OR | typeof NodeType.EQUALS;
    left: QNode;
    right: QNode;
};
export type Literal = BaseNode & {
    type: typeof NodeType.LITERAL;
    value: string;
};
export type FunctionCall = BaseNode & {
    type: typeof NodeType.FUNCTION;
    function: AvailableFunction;
    parameters: QNode[];
};
export type QNode = Selector | Condition | Literal | FunctionCall;
export declare function parse(input: string): QNode;
export {};
//# sourceMappingURL=parseQuery.d.ts.map