"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VISITOR_KEYS = exports.isBinding = exports.isVariableDeclaration = exports.isVariableDeclarator = exports.isFunctionExpression = exports.isFunctionDeclaration = exports.isIdentifier = exports.isMemberExpression = exports.isAssignmentExpression = exports.isUpdateExpression = exports.isPrimitive = exports.isLiteral = exports.isNodePath = exports.isNode = void 0;
exports.isScope = isScope;
exports.isScopable = isScopable;
exports.isExportSpecifier = isExportSpecifier;
const isNode = (candidate) => {
    return typeof candidate === "object" && candidate != null && "type" in candidate;
};
exports.isNode = isNode;
const isNodePath = (candidate) => {
    return typeof candidate === "object" && candidate != null && "node" in candidate;
};
exports.isNodePath = isNodePath;
const isLiteral = (candidate) => {
    return (0, exports.isNode)(candidate) && candidate.type === "Literal";
};
exports.isLiteral = isLiteral;
const isPrimitive = (value) => {
    return typeof value == "string" || typeof value == "number" || typeof value == "boolean";
};
exports.isPrimitive = isPrimitive;
const isUpdateExpression = (value) => {
    return (0, exports.isNode)(value) && value.type === "UpdateExpression";
};
exports.isUpdateExpression = isUpdateExpression;
const isAssignmentExpression = (node) => {
    return node.type === "AssignmentExpression";
};
exports.isAssignmentExpression = isAssignmentExpression;
const isMemberExpression = (node) => {
    return node.type === "MemberExpression";
};
exports.isMemberExpression = isMemberExpression;
const isIdentifier = (node) => {
    return node.type === "Identifier";
};
exports.isIdentifier = isIdentifier;
const isFunctionDeclaration = (node) => {
    return node.type === "FunctionDeclaration";
};
exports.isFunctionDeclaration = isFunctionDeclaration;
const isFunctionExpression = (node) => {
    return node.type === "FunctionExpression";
};
exports.isFunctionExpression = isFunctionExpression;
const isVariableDeclarator = (node) => {
    return node.type === "VariableDeclarator";
};
exports.isVariableDeclarator = isVariableDeclarator;
const isVariableDeclaration = (node) => {
    return node.type === "VariableDeclaration";
};
exports.isVariableDeclaration = isVariableDeclaration;
const isBinding = (node, parentNode, grandParentNode) => {
    if (grandParentNode &&
        node.type === "Identifier" &&
        parentNode.type === "Property" &&
        grandParentNode.type === "ObjectExpression") {
        return false;
    }
    const keys = bindingIdentifiersKeys[parentNode.type] ?? [];
    for (let i = 0; i < keys.length; i++) {
        const key = keys[i];
        const val = 
        // @ts-expect-error key must present in parent
        parentNode[key];
        if (Array.isArray(val)) {
            if (val.indexOf(node) >= 0)
                return true;
        }
        else {
            if (val === node)
                return true;
        }
    }
    return false;
};
exports.isBinding = isBinding;
const bindingIdentifiersKeys = {
    DeclareClass: ["id"],
    DeclareFunction: ["id"],
    DeclareModule: ["id"],
    DeclareVariable: ["id"],
    DeclareInterface: ["id"],
    DeclareTypeAlias: ["id"],
    DeclareOpaqueType: ["id"],
    InterfaceDeclaration: ["id"],
    TypeAlias: ["id"],
    OpaqueType: ["id"],
    CatchClause: ["param"],
    LabeledStatement: ["label"],
    UnaryExpression: ["argument"],
    AssignmentExpression: ["left"],
    ImportSpecifier: ["local"],
    ImportNamespaceSpecifier: ["local"],
    ImportDefaultSpecifier: ["local"],
    ImportDeclaration: ["specifiers"],
    ExportSpecifier: ["exported"],
    ExportNamespaceSpecifier: ["exported"],
    ExportDefaultSpecifier: ["exported"],
    FunctionDeclaration: ["id", "params"],
    FunctionExpression: ["id", "params"],
    ArrowFunctionExpression: ["params"],
    ObjectMethod: ["params"],
    ClassMethod: ["params"],
    ClassPrivateMethod: ["params"],
    ForInStatement: ["left"],
    ForOfStatement: ["left"],
    ClassDeclaration: ["id"],
    ClassExpression: ["id"],
    RestElement: ["argument"],
    UpdateExpression: ["argument"],
    ObjectProperty: ["value"],
    AssignmentPattern: ["left"],
    ArrayPattern: ["elements"],
    ObjectPattern: ["properties"],
    VariableDeclaration: ["declarations"],
    VariableDeclarator: ["id"],
};
exports.VISITOR_KEYS = {
    ArrayExpression: ["elements"],
    ArrayPattern: ["elements"],
    ArrowFunctionExpression: ["params", "body"],
    AssignmentExpression: ["left", "right"],
    AssignmentPattern: ["left", "right"],
    AwaitExpression: ["argument"],
    BinaryExpression: ["left", "right"],
    BlockStatement: ["body"],
    BreakStatement: [],
    CallExpression: ["callee", "arguments"],
    CatchClause: ["param", "body"],
    ChainExpression: ["expression"],
    ClassBody: ["body"],
    ClassDeclaration: ["id", "superClass", "body"],
    ClassExpression: ["id", "superClass", "body"],
    ConditionalExpression: ["test", "consequent", "alternate"],
    ContinueStatement: [],
    DebuggerStatement: [],
    DoWhileStatement: ["body", "test"],
    EmptyStatement: [],
    ExportAllDeclaration: ["source"],
    ExportDefaultDeclaration: ["declaration"],
    ExportNamedDeclaration: ["declaration", "specifiers", "source"],
    ExportSpecifier: ["local", "exported"],
    ExpressionStatement: ["expression"],
    ForInStatement: ["left", "right", "body"],
    ForOfStatement: ["left", "right", "body"],
    ForStatement: ["init", "test", "update", "body"],
    FunctionDeclaration: ["id", "params", "body"],
    FunctionExpression: ["id", "params", "body"],
    Identifier: [],
    IfStatement: ["test", "consequent", "alternate"],
    ImportAttribute: ["key", "value"],
    ImportDeclaration: ["specifiers", "source"],
    ImportDefaultSpecifier: ["local"],
    ImportNamespaceSpecifier: ["local"],
    ImportSpecifier: ["local", "imported"],
    LabeledStatement: ["label", "body"],
    Literal: [],
    LogicalExpression: ["left", "right"],
    MemberExpression: ["object", "property"],
    MetaProperty: ["meta", "property"],
    MethodDefinition: ["key", "value"],
    NewExpression: ["callee", "arguments"],
    ObjectExpression: ["properties"],
    ObjectPattern: ["properties"],
    Program: ["body"],
    Property: ["key", "value"],
    RestElement: ["argument"],
    ReturnStatement: ["argument"],
    SequenceExpression: ["expressions"],
    SpreadElement: ["argument"],
    Super: [],
    SwitchCase: ["test", "consequent"],
    SwitchStatement: ["discriminant", "cases"],
    TaggedTemplateExpression: ["tag", "quasi"],
    TemplateElement: [],
    TemplateLiteral: ["quasis", "expressions"],
    ThisExpression: [],
    ThrowStatement: ["argument"],
    TryStatement: ["block", "handler", "finalizer"],
    UnaryExpression: ["argument"],
    UpdateExpression: ["argument"],
    VariableDeclaration: ["declarations"],
    VariableDeclarator: ["id", "init"],
    WhileStatement: ["test", "body"],
    WithStatement: ["object", "body"],
    YieldExpression: ["argument"],
    ImportExpression: ["source"],
    Decorator: ["expression"],
    PropertyDefinition: ["key", "value"],
    Import: ["source"],
    JSXAttribute: ["name", "value"],
    JSXNamespacedName: ["namespace", "name"],
    JSXElement: ["openingElement", "closingElement", "children"],
    JSXClosingElement: ["name"],
    JSXOpeningElement: ["name", "attributes"],
    JSXFragment: ["openingFragment", "closingFragment", "children"],
    JSXOpeningFragment: [],
    JSXClosingFragment: [],
    JSXText: [],
    JSXExpressionContainer: ["expression"],
    JSXSpreadChild: ["expression"],
    JSXEmptyExpression: [],
    JSXSpreadAttribute: ["argument"],
    JSXIdentifier: [],
    PrivateIdentifier: [],
    JSXMemberExpression: ["object", "property"],
    ParenthesizedExpression: ["expression"],
    StaticBlock: ["body"],
};
function isBlockStatement(node) { return node.type === "BlockStatement"; }
function isFunction(node) {
    return node.type === "FunctionDeclaration" || node.type === "FunctionExpression";
}
function isCatchClause(node) { return node.type === "CatchClause"; }
function isPattern(node) {
    switch (node.type) {
        case "AssignmentPattern":
        case "ArrayPattern":
        case "ObjectPattern":
            return true;
    }
    return false;
}
function isScope(node, parentNode) {
    if (isBlockStatement(node) && (isFunction(parentNode) || isCatchClause(parentNode))) {
        return false;
    }
    if (isPattern(node) && (isFunction(parentNode) || isCatchClause(parentNode))) {
        return true;
    }
    return (0, exports.isFunctionDeclaration)(parentNode) || (0, exports.isFunctionExpression)(parentNode) || isScopable(node);
}
function isScopable(node) {
    switch (node.type) {
        case "BlockStatement":
        case "CatchClause":
        case "DoWhileStatement":
        case "ForInStatement":
        case "ForStatement":
        case "FunctionDeclaration":
        case "FunctionExpression":
        case "Program":
        case "MethodDefinition":
        case "SwitchStatement":
        case "WhileStatement":
        case "ArrowFunctionExpression":
        case "ClassExpression":
        case "ClassDeclaration":
        case "ForOfStatement":
        case "StaticBlock":
            return true;
    }
    return false;
}
function isExportSpecifier(node) {
    return node.type === "ExportSpecifier";
}
