/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.util;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import junit.framework.TestCase;
import net.sf.rej.util.ByteToolkit;
import net.sf.rej.util.StreamByteParser;
import org.junit.Assert;
import org.junit.Test;

public class StreamByteParserTest
extends TestCase {
    @Test
    public final void testGetByte() {
        byte[] data = new byte[]{-54, -2, 0, -70, -66};
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        StreamByteParser parser = new StreamByteParser(bais);
        Assert.assertEquals((String)"ca", (Object)-54, (Object)parser.getByte());
        Assert.assertEquals((String)"fe", (Object)-2, (Object)parser.getByte());
        Assert.assertEquals((String)"00", (Object)0, (Object)parser.getByte());
        Assert.assertEquals((String)"ba", (Object)-70, (Object)parser.getByte());
        Assert.assertEquals((String)"be", (Object)-66, (Object)parser.getByte());
    }

    @Test
    public final void testGetBytes() {
        byte[] data = new byte[]{-54, -2, 0, -70, -66};
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        StreamByteParser parser = new StreamByteParser(bais);
        byte[] firstTwo = parser.getBytes(2);
        byte[] expectedFirstTwo = new byte[]{-54, -2};
        try {
            Assert.assertTrue((String)"Equality of first two bytes", (boolean)Arrays.equals(expectedFirstTwo, firstTwo));
        }
        catch (AssertionError ae) {
            System.out.println("Expected: " + ByteToolkit.byteArrayToDebugString(expectedFirstTwo));
            System.out.println("Result: " + ByteToolkit.byteArrayToDebugString(firstTwo));
            throw ae;
        }
        byte[] rest = parser.getBytes(3);
        byte[] expectedRest = new byte[]{0, -70, -66};
        try {
            Assert.assertTrue((String)"Equality of last threebytes", (boolean)Arrays.equals(expectedRest, rest));
        }
        catch (AssertionError ae) {
            System.out.println("Expected: " + ByteToolkit.byteArrayToDebugString(expectedRest));
            System.out.println("Result: " + ByteToolkit.byteArrayToDebugString(rest));
            throw ae;
        }
    }

    @Test
    public final void testGetByteAsInt() {
        byte[] data = new byte[]{-54, -2, 0, -70, -66};
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        StreamByteParser parser = new StreamByteParser(bais);
        Assert.assertEquals((String)"ca", (Object)202, (Object)parser.getByteAsInt());
        Assert.assertEquals((String)"fe", (Object)254, (Object)parser.getByteAsInt());
        Assert.assertEquals((String)"00", (Object)0, (Object)parser.getByteAsInt());
        Assert.assertEquals((String)"ba", (Object)186, (Object)parser.getByteAsInt());
        Assert.assertEquals((String)"be", (Object)190, (Object)parser.getByteAsInt());
    }

    @Test
    public final void testGetShortAsInt() {
        byte[] data = new byte[]{-54, -2, 0, -70, -66};
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        StreamByteParser parser = new StreamByteParser(bais);
        parser.setBigEndian(true);
        Assert.assertEquals((String)"first short", (Object)51966, (Object)parser.getShortAsInt());
        Assert.assertEquals((String)"second short", (Object)186, (Object)parser.getShortAsInt());
    }

    @Test
    public final void testGetInt() {
        byte[] data = new byte[]{-54, -2, 0, -70, -66};
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        StreamByteParser parser = new StreamByteParser(bais);
        parser.setBigEndian(true);
        long expected = 202L;
        expected *= 256L;
        expected += 254L;
        expected *= 256L;
        expected += 0L;
        expected *= 256L;
        Assert.assertEquals((String)"int", (Object)(expected += 186L), (Object)parser.getInt());
    }

    @Test
    public final void testSetBigEndian() {
        byte[] data = new byte[]{-54, -2, 0, -70, -66};
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        StreamByteParser parser = new StreamByteParser(bais);
        parser.setBigEndian(true);
        Assert.assertEquals((String)"big endian short", (Object)51966, (Object)parser.getShortAsInt());
        parser.setBigEndian(false);
        Assert.assertEquals((String)"little endian short", (Object)47616, (Object)parser.getShortAsInt());
    }

    @Test
    public final void testHasMore() {
        byte[] data = new byte[]{-54, -2, 0, -70, -66};
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        StreamByteParser parser = new StreamByteParser(bais);
        Assert.assertTrue((String)"At the start", (boolean)parser.hasMore());
        parser.getByte();
        Assert.assertTrue((String)"After first", (boolean)parser.hasMore());
        parser.getByte();
        Assert.assertTrue((String)"After second", (boolean)parser.hasMore());
        parser.getByte();
        Assert.assertTrue((String)"After third", (boolean)parser.hasMore());
        parser.getByte();
        Assert.assertTrue((String)"After fourth", (boolean)parser.hasMore());
        parser.getByte();
        Assert.assertFalse((String)"At the end", (boolean)parser.hasMore());
    }

    @Test
    public final void testGetPosition() {
        byte[] data = new byte[]{-54, -2, 0, -70, -66};
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        StreamByteParser parser = new StreamByteParser(bais);
        Assert.assertEquals((String)"start", (Object)0, (Object)parser.getPosition());
        parser.getByte();
        Assert.assertEquals((String)"after read (position 1)", (Object)1, (Object)parser.getPosition());
        parser.peekByte();
        Assert.assertEquals((String)"after peek (position 1)", (Object)1, (Object)parser.getPosition());
        parser.getByte();
        Assert.assertEquals((String)"after read (position 2)", (Object)2, (Object)parser.getPosition());
        parser.getByte();
        Assert.assertTrue((String)"has more", (boolean)parser.hasMore());
        Assert.assertEquals((String)"after hasMore()", (Object)3, (Object)parser.getPosition());
    }

    @Test
    public final void testPeekByte() {
        byte[] data = new byte[]{-54, -2, 0, -70, -66};
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        StreamByteParser parser = new StreamByteParser(bais);
        Assert.assertEquals((String)"ca", (Object)202, (Object)parser.peekByte());
        Assert.assertEquals((String)"ca", (Object)202, (Object)parser.getByteAsInt());
        Assert.assertEquals((String)"fe", (Object)254, (Object)parser.getByteAsInt());
        Assert.assertEquals((String)"00", (Object)0, (Object)parser.peekByte());
        Assert.assertEquals((String)"00", (Object)0, (Object)parser.peekByte());
        Assert.assertEquals((String)"00", (Object)0, (Object)parser.peekByte());
        Assert.assertEquals((String)"00", (Object)0, (Object)parser.getByteAsInt());
        Assert.assertEquals((String)"ba", (Object)186, (Object)parser.getByteAsInt());
        Assert.assertEquals((String)"be", (Object)190, (Object)parser.getByteAsInt());
    }
}

