/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.util;

import java.io.IOException;
import java.io.InputStream;
import net.sf.rej.util.ByteParser;
import net.sf.rej.util.ByteToolkit;
import net.sf.rej.util.CountInputStream;
import net.sf.rej.util.IOToolkit;
import net.sf.rej.util.ParsingException;

public class StreamByteParser
implements ByteParser {
    private CountInputStream in;
    private boolean bigEndian = false;

    public StreamByteParser(InputStream in) {
        this.in = new CountInputStream(in);
    }

    public byte getByte() throws ParsingException {
        try {
            return (byte)this.in.read();
        }
        catch (IOException ioe) {
            throw new ParsingException(ioe);
        }
    }

    public byte[] getBytes(int count) throws ParsingException {
        try {
            return IOToolkit.readStream(count, this.in);
        }
        catch (IOException ioe) {
            throw new ParsingException(ioe);
        }
    }

    public int getByteAsInt() throws ParsingException {
        try {
            return this.in.read();
        }
        catch (IOException ioe) {
            throw new ParsingException(ioe);
        }
    }

    public int getShortAsInt() throws ParsingException {
        int i = (int)ByteToolkit.getLong(this.getBytes(2), 0, 2, this.bigEndian);
        return i;
    }

    public long getInt() throws ParsingException {
        long l = ByteToolkit.getLong(this.getBytes(4), 0, 4, this.bigEndian);
        return l;
    }

    @Deprecated
    public ByteParser getNewParser() throws ParsingException {
        throw new ParsingException("Cannot create a new parser out of a StreamByteParser instance.");
    }

    public void setBigEndian(boolean bigEndian) {
        this.bigEndian = bigEndian;
    }

    public boolean hasMore() throws ParsingException {
        try {
            this.in.mark(1);
            int test = this.in.read();
            this.in.reset();
            return test != -1;
        }
        catch (IOException ioe) {
            throw new ParsingException(ioe);
        }
    }

    public int getPosition() {
        return this.in.getPosition();
    }

    public int peekByte() {
        try {
            this.in.mark(2);
            int i = this.getByteAsInt();
            this.in.reset();
            return i;
        }
        catch (IOException ioe) {
            throw new ParsingException(ioe);
        }
    }
}

