/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;

public class FileToolkit {
    private FileToolkit() {
    }

    public static String readFile(File f) throws IOException {
        int i;
        FileReader fr = new FileReader(f);
        int length = (int)f.length();
        char[] buf = new char[length];
        for (int read = 0; read < length; read += i) {
            i = fr.read(buf, read, length - read);
        }
        fr.close();
        return new String(buf);
    }

    public static byte[] readBytes(File f) throws IOException {
        int i;
        FileInputStream fis = new FileInputStream(f);
        int length = (int)f.length();
        byte[] buf = new byte[length];
        for (int read = 0; read < length; read += i) {
            i = fis.read(buf, read, length - read);
        }
        fis.close();
        return buf;
    }

    public static void writeBytes(File f, byte[] bytes) throws IOException {
        FileOutputStream fos = new FileOutputStream(f, false);
        fos.write(bytes);
        fos.flush();
        fos.close();
    }

    public static void deleteRecursively(File folder) throws IOException {
        if (!folder.exists()) {
            throw new IOException(folder.getPath() + " does not exist.");
        }
        File[] files = folder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                FileToolkit.deleteRecursively(file);
                continue;
            }
            boolean success = file.delete();
            if (success) continue;
            throw new IOException("File " + file.getPath() + " could not be deleted.");
        }
        folder.delete();
    }

    public static File createNewFile(File path, String suffix) {
        long time;
        File test;
        while ((test = new File(path, (time = System.currentTimeMillis()) + suffix)).exists()) {
        }
        return test;
    }
}

