/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;

public class ByteToolkit {
    private static char[] hex = "0123456789abcdef".toCharArray();
    private static MessageDigest md = null;

    public static byte[] getBytes(byte[] data, int pos, int length) {
        byte[] newData = new byte[length];
        for (int i = 0; i < length; ++i) {
            newData[i] = data[i + pos];
        }
        return newData;
    }

    public static long getLong(byte[] data, int pos, int length) {
        long l = 0L;
        for (int i = 0; i < length; ++i) {
            l <<= 8;
            l += (long)ByteToolkit.getByte(data[pos + length - i - 1]);
        }
        return l;
    }

    public static long getLong(byte[] data, int pos, int length, boolean bigEndian) {
        if (bigEndian) {
            long l = 0L;
            for (int i = 0; i < length; ++i) {
                l <<= 8;
                l += (long)ByteToolkit.getByte(data[pos + i]);
            }
            return l;
        }
        long l = 0L;
        for (int i = 0; i < length; ++i) {
            l <<= 8;
            l += (long)ByteToolkit.getByte(data[pos + length - i - 1]);
        }
        return l;
    }

    public static long getSignedLong(byte[] data, int pos, int length, boolean bigEndian) {
        if (bigEndian) {
            long max = 1L;
            long l = 0L;
            for (int i = 0; i < length; ++i) {
                max <<= 8;
                l <<= 8;
                l += (long)ByteToolkit.getByte(data[pos + i]);
            }
            long maxPos = max >> 1;
            if (l >= maxPos) {
                l -= max;
            }
            return l;
        }
        long max = 1L;
        long l = 0L;
        for (int i = 0; i < length; ++i) {
            l <<= 8;
            max <<= 8;
            l += (long)ByteToolkit.getByte(data[pos + length - i - 1]);
        }
        long maxPos = max >> 1;
        if (l >= maxPos) {
            l -= max;
        }
        return l;
    }

    public static int getByte(byte b) {
        int i = b;
        if (b < 0) {
            i = 256 + b;
        }
        return i;
    }

    public static byte[] longToByteArray(long l) {
        byte[] data = null;
        if (l < 256L) {
            data = new byte[]{(byte)l};
            return data;
        }
        if (l < 65536L) {
            data = new byte[2];
            data[1] = (byte)(l & 0xFFL);
            data[0] = (byte)(l / 256L);
            return data;
        }
        throw new RuntimeException("Integer size unsupported @ ByteToolkit.intToByteArray()");
    }

    public static byte[] longToTwoBytes(long l, boolean bigEndian) {
        if (bigEndian) {
            byte[] data = new byte[2];
            data[1] = (byte)(l & 0xFFL);
            data[0] = (byte)(l >> 8);
            return data;
        }
        byte[] data = new byte[]{(byte)(l & 0xFFL), (byte)(l >> 8)};
        return data;
    }

    public static byte[] longToFourBytes(long l, boolean bigEndian) {
        if (bigEndian) {
            byte[] data = new byte[4];
            data[3] = (byte)(l & 0xFFL);
            data[2] = (byte)(l >> 8 & 0xFFL);
            data[1] = (byte)(l >> 16 & 0xFFL);
            data[0] = (byte)(l >> 24 & 0xFFL);
            return data;
        }
        byte[] data = new byte[]{(byte)(l & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 24 & 0xFFL)};
        return data;
    }

    public static String byteArrayToDebugString(byte[] b) {
        return ByteToolkit.byteArrayToDebugString(b, 0, b.length);
    }

    public static String byteArrayToDebugString(byte[] ba, int length) {
        return ByteToolkit.byteArrayToDebugString(ba, 0, length);
    }

    public static String byteArrayToDebugString(byte[] ba, int start, int length) {
        StringBuffer buf = new StringBuffer(10 * length);
        for (int i = start; i < start + length; ++i) {
            int b = ba[i];
            char c = (char)ba[i];
            if (c < ' ') {
                c = '.';
            }
            String str = Integer.toHexString(b);
            if (b < 0) {
                b = 256 + b;
            }
            if (str.length() > 2) {
                str = str.substring(str.length() - 2, str.length());
            }
            buf.append(b + "/0x" + str + "/" + c + " ");
        }
        return buf.toString();
    }

    public static String bytesToHex(String byteStr, int offset) throws Exception {
        char[] lookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int i = 0;
        int c = 0;
        int j = 0;
        String hexStr = null;
        int pos = offset;
        byte[] hex = new byte[32];
        try {
            byte[] bytes = byteStr.getBytes("UTF-8");
            for (i = 0; i < 16; ++i) {
                c = bytes[i] & 0xFF;
                j = c >> 4;
                hex[pos++] = (byte)lookup[j];
                j = c & 0xF;
                hex[pos++] = (byte)lookup[j];
            }
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
        }
        hexStr = new String(hex);
        return hexStr;
    }

    public static String getHexString(long longValue, int size) {
        long l = longValue;
        StringBuffer sb = new StringBuffer();
        if (l >= 0L) {
            for (int i = 0; i < size; ++i) {
                int d = (int)(l & 0xFL);
                l >>= 4;
                sb.insert(0, hex[d]);
            }
        } else {
            l = 0L - l - 1L;
            for (int i = 0; i < size; ++i) {
                int d = (int)(l & 0xFL);
                l >>= 4;
                sb.insert(0, hex[15 - d]);
            }
        }
        return sb.toString();
    }

    public static String getHexString(long l) {
        return ByteToolkit.getHexString(l, 8);
    }

    public static String getHexString(byte[] data, int size) {
        int i;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < size - data.length; ++i) {
            sb.append("00 ");
        }
        for (i = 0; i < data.length; ++i) {
            String str = Integer.toHexString(data[i]);
            if (str.length() == 1) {
                sb.append("0");
            }
            if (str.length() > 2) {
                str = str.substring(str.length() - 2, str.length());
            }
            sb.append(str);
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    public static String getHexString(byte[] data) {
        return ByteToolkit.getHexString(data, data.length);
    }

    public static String byteArrayToPrintableString(byte[] bytes) {
        StringBuffer buf = new StringBuffer(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            char c = (char)bytes[i];
            if (c < ' ') {
                c = '.';
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static boolean areEqual(byte[] bytes1, byte[] bytes2) {
        if (bytes1.length != bytes2.length) {
            return false;
        }
        for (int i = 0; i < bytes1.length; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getMD5(byte[] data) {
        try {
            if (md == null) {
                md = MessageDigest.getInstance("MD5");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            return md.digest(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getMD5(InputStream is) throws IOException {
        try {
            if (md == null) {
                md = MessageDigest.getInstance("MD5");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            int count;
            md.reset();
            byte[] buf = new byte[4096];
            while ((count = is.read(buf)) != -1) {
                md.update(buf, 0, count);
            }
            return md.digest();
        }
    }
}

