/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.util;

import java.io.ByteArrayOutputStream;
import net.sf.rej.util.ByteToolkit;

public class ByteSerializer {
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private boolean bigEndian = false;

    public ByteSerializer(boolean bigEndian) {
        this.bigEndian = bigEndian;
    }

    public byte[] getBytes() {
        return this.baos.toByteArray();
    }

    public void addBytes(byte[] data) {
        this.addBytes(data, 0, data.length);
    }

    public void addBytes(byte[] data, int length) {
        this.addBytes(data, 0, length);
    }

    public void addBytes(byte[] data, int offset, int length) {
        this.baos.write(data, offset, length);
    }

    public void addByte(int b) {
        this.baos.write(b);
    }

    public void addShort(int i) {
        if (i > 65535) {
            throw new RuntimeException("ByteSerializer.addInt(long) does not support integers this big: " + i);
        }
        byte[] data = ByteToolkit.longToTwoBytes(i, this.bigEndian);
        this.addBytes(data);
    }

    public void addInt(long l) {
        byte[] data = ByteToolkit.longToFourBytes(l, this.bigEndian);
        this.addBytes(data);
    }

    public int size() {
        return this.baos.size();
    }
}

