/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.instruction;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.java.instruction.DecompilationContext;
import net.sf.rej.java.instruction.ExecutionContext;
import net.sf.rej.java.instruction.Instruction;
import net.sf.rej.java.instruction.ParameterType;
import net.sf.rej.java.instruction.Parameters;
import net.sf.rej.java.instruction.StackElement;
import net.sf.rej.java.instruction.StackElementType;
import net.sf.rej.util.ByteSerializer;
import net.sf.rej.util.ByteToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class _sipush
extends Instruction {
    public static final int OPCODE = 17;
    public static final String MNEMONIC = "sipush";
    private static final int SIZE = 3;
    private int value = 0;

    @Override
    public int getOpcode() {
        return 17;
    }

    @Override
    public String getMnemonic() {
        return MNEMONIC;
    }

    @Override
    public int getSize() {
        return 3;
    }

    @Override
    public void execute(ExecutionContext ec) {
    }

    @Override
    public void setData(byte[] data, DecompilationContext dc) {
        this.value = (int)ByteToolkit.getLong(data, 1, 2, true);
    }

    @Override
    public byte[] getData(DecompilationContext dc) {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addByte(17);
        ser.addShort(this.value);
        return ser.getBytes();
    }

    @Override
    public Parameters getParameterTypes() {
        Parameters params = new Parameters();
        params.addParam(ParameterType.TYPE_CONSTANT_WIDE);
        return params;
    }

    @Override
    public Parameters getParameters() {
        Parameters params = this.getParameterTypes();
        params.addValue(this.value);
        return params;
    }

    @Override
    public void setParameters(Parameters params) {
        this.value = params.getInt(0);
    }

    @Override
    public List<StackElement> getPushedElements(DecompilationContext dc) {
        ArrayList<StackElement> elements = new ArrayList<StackElement>();
        elements.add(new StackElement("value", StackElementType.INT));
        return elements;
    }
}

