/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.instruction;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.java.instruction.DecompilationContext;
import net.sf.rej.java.instruction.ExecutionContext;
import net.sf.rej.java.instruction.Instruction;
import net.sf.rej.java.instruction.ParameterType;
import net.sf.rej.java.instruction.Parameters;
import net.sf.rej.java.instruction.StackElement;
import net.sf.rej.java.instruction.StackElementType;
import net.sf.rej.util.ByteSerializer;
import net.sf.rej.util.ByteToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class _multianewarray
extends Instruction {
    public static final int OPCODE = 197;
    public static final String MNEMONIC = "multianewarray";
    private static final int SIZE = 4;
    private int index = 0;
    private int dimensions = 0;

    public _multianewarray() {
    }

    public _multianewarray(int index, int dimensions) {
        this.index = index;
        this.dimensions = dimensions;
    }

    @Override
    public int getOpcode() {
        return 197;
    }

    @Override
    public String getMnemonic() {
        return MNEMONIC;
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public void execute(ExecutionContext ec) {
    }

    @Override
    public void setData(byte[] data, DecompilationContext dc) {
        this.index = (int)ByteToolkit.getLong(data, 1, 2, true);
        this.dimensions = (int)ByteToolkit.getLong(data, 3, 1, true);
    }

    @Override
    public byte[] getData(DecompilationContext dc) {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addByte(197);
        ser.addShort(this.index);
        ser.addByte(this.dimensions);
        return ser.getBytes();
    }

    @Override
    public Parameters getParameters() {
        Parameters params = this.getParameterTypes();
        params.addValue(this.index);
        params.addValue(this.dimensions);
        return params;
    }

    @Override
    public Parameters getParameterTypes() {
        return new Parameters(new ParameterType[]{ParameterType.TYPE_CONSTANT_POOL_CLASS, ParameterType.TYPE_CONSTANT});
    }

    @Override
    public void setParameters(Parameters params) {
        this.index = params.getInt(0);
        this.dimensions = params.getInt(1);
    }

    @Override
    public List<StackElement> getPoppedElements(DecompilationContext dc) {
        ArrayList<StackElement> elements = new ArrayList<StackElement>();
        for (int i = 0; i < this.dimensions; ++i) {
            elements.add(new StackElement("count" + (i + 1), StackElementType.INT));
        }
        return elements;
    }

    @Override
    public List<StackElement> getPushedElements(DecompilationContext dc) {
        ArrayList<StackElement> elements = new ArrayList<StackElement>();
        elements.add(new StackElement("arrayref", StackElementType.REF));
        return elements;
    }
}

