/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.instruction;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.java.constantpool.FloatInfo;
import net.sf.rej.java.constantpool.IntegerInfo;
import net.sf.rej.java.constantpool.StringInfo;
import net.sf.rej.java.instruction.DecompilationContext;
import net.sf.rej.java.instruction.ExecutionContext;
import net.sf.rej.java.instruction.Instruction;
import net.sf.rej.java.instruction.ParameterType;
import net.sf.rej.java.instruction.Parameters;
import net.sf.rej.java.instruction.StackElement;
import net.sf.rej.java.instruction.StackElementType;
import net.sf.rej.util.ByteSerializer;
import net.sf.rej.util.ByteToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class _ldc
extends Instruction {
    public static final int OPCODE = 18;
    public static final String MNEMONIC = "ldc";
    private static final int SIZE = 2;
    private int index = 0;

    public _ldc() {
    }

    public _ldc(int index) {
        if (index > 255) {
            throw new RuntimeException("_ldc(int) index out of range.");
        }
        this.index = index;
    }

    @Override
    public void setData(byte[] data, DecompilationContext dc) {
        this.index = (int)ByteToolkit.getLong(data, 1, 1, true);
    }

    @Override
    public byte[] getData(DecompilationContext dc) {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addByte(18);
        ser.addByte(this.index);
        return ser.getBytes();
    }

    @Override
    public int getOpcode() {
        return 18;
    }

    @Override
    public String getMnemonic() {
        return MNEMONIC;
    }

    @Override
    public int getSize() {
        return 2;
    }

    @Override
    public void execute(ExecutionContext ec) {
    }

    @Override
    public Parameters getParameters() {
        Parameters params = this.getParameterTypes();
        params.addValue(this.index);
        return params;
    }

    @Override
    public Parameters getParameterTypes() {
        return new Parameters(new ParameterType[]{ParameterType.TYPE_CONSTANT_POOL_CONSTANT});
    }

    @Override
    public void setParameters(Parameters params) {
        this.index = params.getInt(0);
    }

    @Override
    public List<StackElement> getPushedElements(DecompilationContext dc) {
        ArrayList<StackElement> elements = new ArrayList<StackElement>();
        ConstantPoolInfo cpi = dc.getConstantPool().get(this.index);
        if (cpi instanceof IntegerInfo) {
            elements.add(new StackElement("value", StackElementType.INT));
        } else if (cpi instanceof FloatInfo) {
            elements.add(new StackElement("value", StackElementType.FLOAT));
        } else if (cpi instanceof StringInfo) {
            elements.add(new StackElement("value", StackElementType.REF));
        } else {
            throw new AssertionError((Object)("ldc points to an invalid item on the constant pool: " + cpi.getClass()));
        }
        return elements;
    }
}

