/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.instruction;

import net.sf.rej.java.instruction.DecompilationContext;
import net.sf.rej.java.instruction.ExecutionContext;
import net.sf.rej.java.instruction.Instruction;
import net.sf.rej.java.instruction.ParameterType;
import net.sf.rej.java.instruction.Parameters;
import net.sf.rej.java.instruction.Widenable;
import net.sf.rej.util.ByteSerializer;
import net.sf.rej.util.ByteToolkit;

public class _iinc
extends Instruction
implements Widenable {
    public static final int OPCODE = 132;
    public static final String MNEMONIC = "iinc";
    private static final int SIZE = 3;
    private static final int WIDE_SIZE = 6;
    private int index = 0;
    private int increment = 0;

    public _iinc() {
    }

    public _iinc(int localVariable, int increment) {
        this.index = localVariable;
        this.increment = increment;
    }

    public int getOpcode() {
        return 132;
    }

    public String getMnemonic() {
        return MNEMONIC;
    }

    public int getSize() {
        return 3;
    }

    public void execute(ExecutionContext ec) {
    }

    public void setData(byte[] data, DecompilationContext dc) {
        this.index = (int)ByteToolkit.getLong(data, 1, 1, true);
        this.increment = (int)ByteToolkit.getLong(data, 2, 1, true);
    }

    public byte[] getData(DecompilationContext dc) {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addByte(132);
        ser.addByte(this.index);
        ser.addByte(this.increment);
        return ser.getBytes();
    }

    public int getWideSize(DecompilationContext dc) {
        return 6;
    }

    public byte[] getWideData(DecompilationContext dc) {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addByte(196);
        ser.addByte(132);
        ser.addShort(this.index);
        ser.addShort(this.increment);
        return ser.getBytes();
    }

    public void setWideData(byte[] data, DecompilationContext dc) {
        this.index = (int)ByteToolkit.getLong(data, 2, 2, true);
        this.increment = (int)ByteToolkit.getLong(data, 4, 2, true);
    }

    public Parameters getParameters() {
        Parameters params = this.getParameterTypes();
        params.addValue(this.index);
        params.addValue(this.increment);
        return params;
    }

    public Parameters getParametersWide() {
        Parameters params = this.getParameterTypesWide();
        params.addValue(this.index);
        params.addValue(this.increment);
        return params;
    }

    public Parameters getParameterTypes() {
        return new Parameters(new ParameterType[]{ParameterType.TYPE_LOCAL_VARIABLE, ParameterType.TYPE_CONSTANT});
    }

    public Parameters getParameterTypesWide() {
        return new Parameters(new ParameterType[]{ParameterType.TYPE_LOCAL_VARIABLE_WIDE, ParameterType.TYPE_CONSTANT_WIDE});
    }

    public void setParameters(Parameters params) {
        this.index = params.getInt(0);
        this.increment = params.getInt(1);
    }

    public void setParametersWide(Parameters params) {
        this.index = params.getInt(0);
        this.increment = params.getInt(1);
    }
}

