/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.instruction;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.java.instruction.DecompilationContext;
import net.sf.rej.java.instruction.ExecutionContext;
import net.sf.rej.java.instruction.Instruction;
import net.sf.rej.java.instruction.Label;
import net.sf.rej.java.instruction.ParameterType;
import net.sf.rej.java.instruction.Parameters;
import net.sf.rej.java.instruction.StackElement;
import net.sf.rej.java.instruction.StackElementType;
import net.sf.rej.util.ByteSerializer;
import net.sf.rej.util.ByteToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class _ifnonnull
extends Instruction {
    public static final int OPCODE = 199;
    public static final String MNEMONIC = "ifnonnull";
    private static final int SIZE = 3;
    private Label label = null;

    public _ifnonnull() {
    }

    public _ifnonnull(Label label) {
        this.label = label;
    }

    @Override
    public int getOpcode() {
        return 199;
    }

    @Override
    public String getMnemonic() {
        return MNEMONIC;
    }

    @Override
    public int getSize() {
        return 3;
    }

    @Override
    public void execute(ExecutionContext ec) {
    }

    @Override
    public void setData(byte[] data, DecompilationContext dc) {
        int addr = (int)ByteToolkit.getSignedLong(data, 1, 2, true) + dc.getPosition();
        this.label = new Label(addr);
    }

    @Override
    public byte[] getData(DecompilationContext dc) {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addByte(199);
        ser.addShort(this.label.getPosition() - dc.getPosition());
        return ser.getBytes();
    }

    @Override
    public List<Label> getLabels() {
        ArrayList<Label> al = new ArrayList<Label>();
        al.add(this.label);
        return al;
    }

    @Override
    public Parameters getParameters() {
        Parameters params = this.getParameterTypes();
        params.addValue(this.label);
        return params;
    }

    @Override
    public Parameters getParameterTypes() {
        return new Parameters(new ParameterType[]{ParameterType.TYPE_LABEL});
    }

    @Override
    public void setParameters(Parameters params) {
        this.label = (Label)params.getObject(0);
    }

    @Override
    public List<StackElement> getPoppedElements(DecompilationContext dc) {
        ArrayList<StackElement> elements = new ArrayList<StackElement>();
        elements.add(new StackElement("value", StackElementType.REF));
        return elements;
    }
}

