/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.instruction;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.java.instruction.DecompilationContext;
import net.sf.rej.java.instruction.ExecutionContext;
import net.sf.rej.java.instruction.Instruction;
import net.sf.rej.java.instruction.ParameterType;
import net.sf.rej.java.instruction.Parameters;
import net.sf.rej.java.instruction.StackElement;
import net.sf.rej.java.instruction.StackElementType;
import net.sf.rej.java.instruction.Widenable;
import net.sf.rej.util.ByteSerializer;
import net.sf.rej.util.ByteToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class _dstore
extends Instruction
implements Widenable {
    public static final int OPCODE = 57;
    public static final String MNEMONIC = "dstore";
    public static final int SIZE = 2;
    private static final int WIDE_SIZE = 4;
    private int index = 0;

    public _dstore() {
    }

    public _dstore(int localVariable) {
        this.index = localVariable;
    }

    @Override
    public int getOpcode() {
        return 57;
    }

    @Override
    public String getMnemonic() {
        return MNEMONIC;
    }

    @Override
    public int getSize() {
        return 2;
    }

    @Override
    public void execute(ExecutionContext ec) {
    }

    @Override
    public void setData(byte[] data, DecompilationContext dc) {
        this.index = (int)ByteToolkit.getLong(data, 1, 1, true);
    }

    @Override
    public byte[] getData(DecompilationContext dc) {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addByte(57);
        ser.addByte(this.index);
        return ser.getBytes();
    }

    @Override
    public Parameters getParameters() {
        Parameters params = this.getParameterTypes();
        params.addValue(this.index);
        return params;
    }

    @Override
    public Parameters getParametersWide() {
        Parameters params = this.getParameterTypesWide();
        params.addValue(this.index);
        return params;
    }

    @Override
    public Parameters getParameterTypes() {
        return new Parameters(new ParameterType[]{ParameterType.TYPE_LOCAL_VARIABLE});
    }

    @Override
    public Parameters getParameterTypesWide() {
        return new Parameters(new ParameterType[]{ParameterType.TYPE_LOCAL_VARIABLE_WIDE});
    }

    @Override
    public void setParameters(Parameters params) {
        this.index = params.getInt(0);
    }

    @Override
    public int getWideSize(DecompilationContext dc) {
        return 4;
    }

    @Override
    public void setWideData(byte[] data, DecompilationContext dc) {
        this.index = (int)ByteToolkit.getLong(data, 2, 2, true);
    }

    @Override
    public byte[] getWideData(DecompilationContext dc) {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addByte(196);
        ser.addByte(57);
        ser.addShort(this.index);
        return ser.getBytes();
    }

    @Override
    public void setParametersWide(Parameters params) {
        this.index = params.getInt(0);
    }

    @Override
    public List<StackElement> getPoppedElements(DecompilationContext dc) {
        ArrayList<StackElement> elements = new ArrayList<StackElement>();
        elements.add(new StackElement("value", StackElementType.DOUBLE));
        return elements;
    }
}

