/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.instruction;

import java.util.List;
import net.sf.rej.java.instruction.DecompilationContext;
import net.sf.rej.java.instruction.ExecutionContext;
import net.sf.rej.java.instruction.Label;
import net.sf.rej.java.instruction.Parameters;
import net.sf.rej.java.instruction.StackElement;
import net.sf.rej.util.ImmutableEmptyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Instruction {
    private static final List<Label> EMPTY_LABEL_LIST = new ImmutableEmptyList<Label>();
    private static final List<StackElement> EMPTY_STACK_ELEMENT_LIST = new ImmutableEmptyList<StackElement>();

    protected Instruction() {
    }

    public abstract int getOpcode();

    public abstract String getMnemonic();

    public abstract int getSize();

    public abstract void execute(ExecutionContext var1);

    public int getSize(DecompilationContext dc) {
        return this.getSize();
    }

    public abstract void setData(byte[] var1, DecompilationContext var2);

    public abstract byte[] getData(DecompilationContext var1);

    public abstract Parameters getParameters();

    public abstract Parameters getParameterTypes();

    public abstract void setParameters(Parameters var1);

    public List<Label> getLabels() {
        return EMPTY_LABEL_LIST;
    }

    public String toString() {
        return this.getMnemonic();
    }

    public Instruction createNewInstance() throws InstantiationException, IllegalAccessException {
        return (Instruction)this.getClass().newInstance();
    }

    public List<StackElement> getPushedElements(DecompilationContext dc) {
        return EMPTY_STACK_ELEMENT_LIST;
    }

    public List<StackElement> getPoppedElements(DecompilationContext dc) {
        return EMPTY_STACK_ELEMENT_LIST;
    }
}

