/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.constantpool;

import java.io.UnsupportedEncodingException;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.util.ByteSerializer;

public class UTF8Info
extends ConstantPoolInfo {
    private String value;

    public UTF8Info(String string, ConstantPool pool) {
        super(1, pool);
        this.value = string;
    }

    public UTF8Info(byte[] bytes, ConstantPool pool) {
        super(1, pool);
        try {
            this.value = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "(utf-8) " + this.value;
    }

    public String getValue() {
        return this.value;
    }

    public void setString(String newValue) {
        this.value = newValue;
    }

    public byte[] getData() {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addByte(this.getType());
        try {
            byte[] data = this.value.getBytes("UTF-8");
            ser.addShort(data.length);
            ser.addBytes(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ser.getBytes();
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        try {
            return this.value.equals(((UTF8Info)other).value);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public String getTypeString() {
        return "UTF-8 Text";
    }
}

