/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.constantpool;

import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.java.constantpool.UTF8Info;
import net.sf.rej.util.ByteSerializer;

public class StringInfo
extends ConstantPoolInfo {
    private int stringIndex;

    public StringInfo(int stringIndex, ConstantPool pool) {
        super(8, pool);
        this.stringIndex = stringIndex;
    }

    public String toString() {
        return "(string) index " + this.stringIndex + "(" + this.pool.get(this.stringIndex) + ")";
    }

    public byte[] getData() {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addByte(this.getType());
        ser.addShort(this.stringIndex);
        return ser.getBytes();
    }

    public String getString() {
        return ((UTF8Info)this.pool.get(this.stringIndex)).getValue();
    }

    public String getValue() {
        ConstantPoolInfo cpi = this.pool.get(this.stringIndex);
        if (cpi == null) {
            return "String Info refers to a null item on the constant pool.";
        }
        if (!(cpi instanceof UTF8Info)) {
            return "String Info refers to an item of wrong type (" + cpi.getTypeString() + ").";
        }
        return "\"" + this.getString() + "\"";
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        try {
            return this.getString().equals(((StringInfo)other).getString());
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public String getTypeString() {
        return "String Constant";
    }

    public String getStringValue() {
        UTF8Info info = (UTF8Info)this.pool.get(this.stringIndex);
        return info.getValue();
    }

    public UTF8Info getUTF8Info() {
        return (UTF8Info)this.pool.get(this.stringIndex);
    }

    public int getUTF8Index() {
        return this.stringIndex;
    }

    public void createNewUTF8String(String newString) {
        this.stringIndex = this.pool.optionalAddUtf8(newString);
    }

    public void setUTF8Index(int index) {
        this.stringIndex = index;
    }
}

