/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.constantpool;

import net.sf.rej.java.Descriptor;
import net.sf.rej.java.constantpool.ClassInfo;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.java.constantpool.NameAndTypeInfo;
import net.sf.rej.util.ByteSerializer;

public class RefInfo
extends ConstantPoolInfo {
    private int tag;
    private int classIndex;
    private int nameAndTypeIndex;

    public RefInfo(int tag, int classIndex, int nameAndTypeIndex, ConstantPool pool) {
        super(tag, pool);
        this.tag = tag;
        this.classIndex = classIndex;
        this.nameAndTypeIndex = nameAndTypeIndex;
    }

    public String toString() {
        Descriptor desc = this.getDescriptor();
        return desc.getReturn() + " " + this.getClassName() + "." + this.getTargetName() + "(" + desc.getParams() + ")";
    }

    public String getClassName() {
        ClassInfo ci = (ClassInfo)this.pool.get(this.classIndex);
        return ci.getName();
    }

    public String getTargetName() {
        NameAndTypeInfo info = (NameAndTypeInfo)this.pool.get(this.nameAndTypeIndex);
        return info.getName();
    }

    public String getMethodType() {
        NameAndTypeInfo info = (NameAndTypeInfo)this.pool.get(this.nameAndTypeIndex);
        return info.getDescriptorString();
    }

    public Descriptor getDescriptor() {
        NameAndTypeInfo info = (NameAndTypeInfo)this.pool.get(this.nameAndTypeIndex);
        return info.getDescriptor();
    }

    public byte[] getData() {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addByte(this.getType());
        ser.addShort(this.classIndex);
        ser.addShort(this.nameAndTypeIndex);
        return ser.getBytes();
    }

    public NameAndTypeInfo getNameAndTypeInfo() {
        NameAndTypeInfo info = (NameAndTypeInfo)this.pool.get(this.nameAndTypeIndex);
        return info;
    }

    public int hashCode() {
        int i = this.getClassName().hashCode();
        i += this.getTargetName().hashCode();
        i += this.tag;
        return i += this.getMethodType().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        try {
            RefInfo ref = (RefInfo)other;
            if (this.tag != ref.tag) {
                return false;
            }
            if (!this.getClassName().equals(ref.getClassName())) {
                return false;
            }
            if (!this.getTargetName().equals(ref.getTargetName())) {
                return false;
            }
            return this.getMethodType().equals(ref.getMethodType());
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public String getTypeString() {
        switch (this.tag) {
            case 9: {
                return "Fieldref";
            }
            case 11: {
                return "InterfaceMethodref";
            }
            case 10: {
                return "Methodref";
            }
        }
        throw new RuntimeException("Internal error, undefined Ref type = " + this.tag);
    }
}

