/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.constantpool;

import java.util.Arrays;
import junit.framework.TestCase;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.FloatInfo;
import net.sf.rej.util.ByteToolkit;
import org.junit.Assert;
import org.junit.Test;

public class FloatInfoTest
extends TestCase {
    @Test
    public final void testGetData() {
        FloatInfo fi = new FloatInfo(0, new ConstantPool());
        byte[] data = fi.getData();
        byte[] expected = new byte[]{4, 0, 0, 0, 0};
        try {
            Assert.assertTrue((String)"0", (boolean)Arrays.equals(expected, data));
        }
        catch (AssertionError ae) {
            System.out.println("Expected: " + ByteToolkit.byteArrayToDebugString(expected));
            System.out.println("Result: " + ByteToolkit.byteArrayToDebugString(data));
            throw ae;
        }
        fi = new FloatInfo(19, new ConstantPool());
        data = fi.getData();
        expected = new byte[]{4, 0, 0, 0, 19};
        try {
            Assert.assertTrue((String)"19", (boolean)Arrays.equals(expected, data));
        }
        catch (AssertionError ae) {
            System.out.println("Expected: " + ByteToolkit.byteArrayToDebugString(expected));
            System.out.println("Result: " + ByteToolkit.byteArrayToDebugString(data));
            throw ae;
        }
        fi = new FloatInfo(258, new ConstantPool());
        data = fi.getData();
        expected = new byte[]{4, 0, 0, 1, 2};
        try {
            Assert.assertTrue((String)"258", (boolean)Arrays.equals(expected, data));
        }
        catch (AssertionError ae) {
            System.out.println("Expected: " + ByteToolkit.byteArrayToDebugString(expected));
            System.out.println("Result: " + ByteToolkit.byteArrayToDebugString(data));
            throw ae;
        }
    }

    @Test
    public final void testGetTypeString() {
        ConstantPool cp = new ConstantPool();
        FloatInfo fi = new FloatInfo(0, cp);
        Assert.assertEquals((String)"type string", (Object)"Float constant", (Object)fi.getTypeString());
    }

    @Test
    public final void testFloatInfoIntConstantPool() {
        FloatInfo fi = new FloatInfo(0, new ConstantPool());
        Assert.assertEquals((String)"0", (Object)0, (Object)fi.getBytes());
        fi = new FloatInfo(1, new ConstantPool());
        Assert.assertEquals((String)"1", (Object)1, (Object)fi.getBytes());
    }

    @Test
    public final void testFloatInfoFloatConstantPool() {
        FloatInfo fi = new FloatInfo(0.0f, new ConstantPool());
        Assert.assertEquals((String)"0.0f", (Object)Float.valueOf(0.0f), (Object)Float.valueOf(fi.getFloatValue()));
        fi = new FloatInfo(1.1f, new ConstantPool());
        Assert.assertEquals((String)"1.1f", (Object)Float.valueOf(1.1f), (Object)Float.valueOf(fi.getFloatValue()));
        fi = new FloatInfo(-1.1f, new ConstantPool());
        Assert.assertEquals((String)"-1.1f", (Object)Float.valueOf(-1.1f), (Object)Float.valueOf(fi.getFloatValue()));
    }

    @Test
    public final void testEqualsObject() {
        FloatInfo a = new FloatInfo(0.0f, new ConstantPool());
        Assert.assertTrue((String)"same instance", (boolean)a.equals(a));
        FloatInfo b = new FloatInfo(0.0f, new ConstantPool());
        Assert.assertTrue((String)"both zero a.equals(b)", (boolean)a.equals(b));
        Assert.assertTrue((String)"both zero b.equals(a)", (boolean)b.equals(a));
        b.setFloatValue(1.0f);
        Assert.assertFalse((String)"a=0, b=1 a.equals(b)", (boolean)a.equals(b));
        Assert.assertFalse((String)"a=0, b=1 b.equals(a)", (boolean)b.equals(a));
        a.setFloatValue(Float.NaN);
        Assert.assertFalse((String)"a=NaN, b=1 a.equals(b)", (boolean)a.equals(b));
        Assert.assertFalse((String)"a=NaN, b=1 b.equals(a)", (boolean)b.equals(a));
        b.setFloatValue(Float.NaN);
        Assert.assertTrue((String)"a=NaN, b=NaN a.equals(b)", (boolean)a.equals(b));
        Assert.assertTrue((String)"a=NaN, b=NaN b.equals(a)", (boolean)b.equals(a));
        a.setFloatValue(Float.POSITIVE_INFINITY);
        Assert.assertFalse((String)"a=positive inf, b=NaN a.equals(b)", (boolean)a.equals(b));
        Assert.assertFalse((String)"a=positive inf, b=NaN b.equals(a)", (boolean)b.equals(a));
        b.setFloatValue(3.5f);
        a.setFloatValue(Float.NEGATIVE_INFINITY);
        Assert.assertFalse((String)"a=negative inf, b=3.5f a.equals(b)", (boolean)a.equals(b));
        Assert.assertFalse((String)"a=negative inf, b=3.5f b.equals(a)", (boolean)b.equals(a));
        b.setFloatValue(3.5f);
        a.setFloatValue(3.5f);
        Assert.assertTrue((String)"a=3.5f, b=3.5f a.equals(b)", (boolean)a.equals(b));
        Assert.assertTrue((String)"a=3.5f, b=3.5f b.equals(a)", (boolean)b.equals(a));
        a.setFloatValue(-3.5f);
        Assert.assertFalse((String)"a=-3.5f, b=3.5f a.equals(b)", (boolean)a.equals(b));
        Assert.assertFalse((String)"a=-3.5f, b=3.5f b.equals(a)", (boolean)b.equals(a));
    }

    @Test
    public final void testGetFloatValue() {
        ConstantPool cp = new ConstantPool();
        FloatInfo fi = new FloatInfo(1.0f, cp);
        Assert.assertEquals((String)"1.0f", (Object)Float.valueOf(1.0f), (Object)Float.valueOf(fi.getFloatValue()));
        fi = new FloatInfo(0.0f, cp);
        Assert.assertEquals((String)"0.0f", (Object)Float.valueOf(0.0f), (Object)Float.valueOf(fi.getFloatValue()));
        fi = new FloatInfo(-1.0f, cp);
        Assert.assertEquals((String)"-1.0f", (Object)Float.valueOf(-1.0f), (Object)Float.valueOf(fi.getFloatValue()));
        fi = new FloatInfo(618.8f, cp);
        Assert.assertEquals((String)"618.8f", (Object)Float.valueOf(618.8f), (Object)Float.valueOf(fi.getFloatValue()));
        fi = new FloatInfo(Float.NEGATIVE_INFINITY, cp);
        Assert.assertEquals((String)"negative infinity", (Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(fi.getFloatValue()));
        fi = new FloatInfo(Float.POSITIVE_INFINITY, cp);
        Assert.assertEquals((String)"positive infinity", (Object)Float.valueOf(Float.POSITIVE_INFINITY), (Object)Float.valueOf(fi.getFloatValue()));
        fi = new FloatInfo(Float.NaN, cp);
        Assert.assertEquals((String)"not a number", (Object)Float.valueOf(Float.NaN), (Object)Float.valueOf(fi.getFloatValue()));
    }

    @Test
    public final void testSetFloatValue() {
        ConstantPool cp = new ConstantPool();
        FloatInfo fi = new FloatInfo(0.0f, cp);
        fi.setFloatValue(1.0f);
        Assert.assertEquals((String)"1.0f", (Object)Float.valueOf(1.0f), (Object)Float.valueOf(fi.getFloatValue()));
        fi.setFloatValue(0.0f);
        Assert.assertEquals((String)"0.0f", (Object)Float.valueOf(0.0f), (Object)Float.valueOf(fi.getFloatValue()));
        fi.setFloatValue(-1.0f);
        Assert.assertEquals((String)"-1.0f", (Object)Float.valueOf(-1.0f), (Object)Float.valueOf(fi.getFloatValue()));
        fi.setFloatValue(618.8f);
        Assert.assertEquals((String)"618.8f", (Object)Float.valueOf(618.8f), (Object)Float.valueOf(fi.getFloatValue()));
        fi.setFloatValue(Float.NEGATIVE_INFINITY);
        Assert.assertEquals((String)"negative infinity", (Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(fi.getFloatValue()));
        fi.setFloatValue(Float.POSITIVE_INFINITY);
        Assert.assertEquals((String)"positive infinity", (Object)Float.valueOf(Float.POSITIVE_INFINITY), (Object)Float.valueOf(fi.getFloatValue()));
        fi.setFloatValue(Float.NaN);
        Assert.assertEquals((String)"not a number", (Object)Float.valueOf(Float.NaN), (Object)Float.valueOf(fi.getFloatValue()));
    }

    @Test
    public final void testGetBytes() {
        FloatInfo fi = new FloatInfo(0, new ConstantPool());
        Assert.assertEquals((String)"0", (Object)0, (Object)fi.getBytes());
        fi = new FloatInfo(1, new ConstantPool());
        Assert.assertEquals((String)"1", (Object)1, (Object)fi.getBytes());
    }
}

