/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.constantpool;

import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.util.ByteSerializer;

public class DoubleInfo
extends ConstantPoolInfo {
    private long highBytes;
    private long lowBytes;

    public DoubleInfo(long highBytes, long lowBytes, ConstantPool pool) {
        super(6, pool);
        this.highBytes = highBytes;
        this.lowBytes = lowBytes;
    }

    public DoubleInfo(double value, ConstantPool pool) {
        super(6, pool);
        this.setDoubleValue(value);
    }

    public String toString() {
        return "(double) " + String.valueOf(this.getDoubleValue());
    }

    public byte[] getData() {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addByte(this.getType());
        ser.addInt(this.highBytes);
        ser.addInt(this.lowBytes);
        return ser.getBytes();
    }

    public int hashCode() {
        return (int)this.highBytes + (int)this.lowBytes;
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof DoubleInfo) {
            return this.lowBytes == ((DoubleInfo)other).lowBytes && this.highBytes == ((DoubleInfo)other).highBytes;
        }
        return false;
    }

    public String getTypeString() {
        return "Double constant";
    }

    public double getDoubleValue() {
        long bits = (this.highBytes << 32) + this.lowBytes;
        return Double.longBitsToDouble(bits);
    }

    public void setDoubleValue(double newValue) {
        long raw = Double.doubleToRawLongBits(newValue);
        this.lowBytes = raw & 0xFFFFFFFFL;
        this.highBytes = raw >> 32;
    }

    public long getLowBytes() {
        return this.lowBytes;
    }

    public long getHighBytes() {
        return this.highBytes;
    }
}

