/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.constantpool;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.rej.java.constantpool.ClassInfo;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.java.constantpool.NameAndTypeInfo;
import net.sf.rej.java.constantpool.RefInfo;
import net.sf.rej.java.constantpool.StringInfo;
import net.sf.rej.java.constantpool.UTF8Info;
import net.sf.rej.util.ByteSerializer;
import net.sf.rej.util.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantPool
implements Iterable<ConstantPoolInfo> {
    private List<ConstantPoolInfo> cpi = new ArrayList<ConstantPoolInfo>();

    public ConstantPool() {
        this.cpi.add(null);
    }

    public void init(int size) {
        this.cpi = new ArrayList<ConstantPoolInfo>(size);
        for (int i = 0; i < size; ++i) {
            this.cpi.add(null);
        }
    }

    public ConstantPoolInfo get(int i) {
        return this.cpi.get(i);
    }

    public void set(int i, ConstantPoolInfo info) {
        this.cpi.set(i, info);
    }

    public int size() {
        return this.cpi.size();
    }

    public int indexOf(ConstantPoolInfo item) {
        return this.cpi.indexOf(item);
    }

    public int optionalAdd(ConstantPoolInfo item) {
        int i = this.cpi.indexOf(item);
        if (i != -1) {
            return i;
        }
        return this.forceAdd(item);
    }

    public int forceAdd(ConstantPoolInfo item) {
        this.cpi.add(item);
        if (item.getType() == 6 || item.getType() == 5) {
            this.cpi.add(null);
            return this.size() - 2;
        }
        return this.size() - 1;
    }

    public int optionalAddFieldRef(String className, String fieldName, String type) {
        int index = this.indexOfFieldRef(className, fieldName, type);
        if (index != -1) {
            return index;
        }
        int classIndex = this.optionalAddClassRef(className);
        int nameAndTypeIndex = this.optionalAddNameAndTypeRef(fieldName, type);
        RefInfo ref = new RefInfo(9, classIndex, nameAndTypeIndex, this);
        return this.optionalAdd(ref);
    }

    public int optionalAddMethodRef(String className, String methodName, String type) {
        int index = this.indexOfMethodRef(className, methodName, type);
        if (index != -1) {
            return index;
        }
        int classIndex = this.optionalAddClassRef(className);
        int nameAndTypeIndex = this.optionalAddNameAndTypeRef(methodName, type);
        RefInfo ref = new RefInfo(10, classIndex, nameAndTypeIndex, this);
        return this.forceAdd(ref);
    }

    public int optionalAddNameAndTypeRef(String methodName, String type) {
        int index = this.indexOfNameAndTypeRef(methodName, type);
        if (index != -1) {
            return index;
        }
        int nameIndex = this.optionalAddUtf8(methodName);
        int descriptorIndex = this.optionalAddUtf8(type);
        NameAndTypeInfo info = new NameAndTypeInfo(nameIndex, descriptorIndex, this);
        return this.optionalAdd(info);
    }

    public int optionalAddClassRef(String className) {
        int index = this.indexOfClassRef(className);
        if (index != -1) {
            return index;
        }
        int nameIndex = this.optionalAddUtf8(className.replace('.', '/'));
        ClassInfo ci = new ClassInfo(nameIndex, this);
        return this.optionalAdd(ci);
    }

    public int forceAddClassRef(String className) {
        int nameIndex = this.optionalAddUtf8(className.replace('.', '/'));
        ClassInfo ci = new ClassInfo(nameIndex, this);
        return this.forceAdd(ci);
    }

    public int optionalAddUtf8(String text) {
        int index = this.indexOfUtf8(text);
        if (index != -1) {
            return index;
        }
        return this.optionalAdd(new UTF8Info(text, this));
    }

    public int optionalAddString(String text) {
        for (int i = 0; i < this.size(); ++i) {
            StringInfo si;
            if (this.get(i) == null || this.get(i).getType() != 8 || !text.equals((si = (StringInfo)this.get(i)).getString())) continue;
            return i;
        }
        int utf8 = this.optionalAddUtf8(text);
        return this.optionalAdd(new StringInfo(utf8, this));
    }

    public void removeLast(int index) {
        assert (this.cpi.size() - 1 == index) : "Index mismatch, only the last item of the constant pool may be removed.";
        this.removeLast();
    }

    public void removeLast() {
        this.cpi.remove(this.cpi.size() - 1);
    }

    public int indexOfClassRef(String className) {
        for (int i = 0; i < this.size(); ++i) {
            ClassInfo ci;
            if (this.get(i) == null || this.get(i).getType() != 7 || !className.equals((ci = (ClassInfo)this.get(i)).getName())) continue;
            return i;
        }
        return -1;
    }

    public int indexOfNameAndTypeRef(String methodName, String type) {
        for (int i = 0; i < this.size(); ++i) {
            NameAndTypeInfo info;
            if (this.get(i) == null || this.get(i).getType() != 12 || !methodName.equals((info = (NameAndTypeInfo)this.get(i)).getName()) || !type.equals(info.getDescriptorString())) continue;
            return i;
        }
        return -1;
    }

    public int indexOfFieldRef(String className, String fieldName, String type) {
        for (int i = 0; i < this.size(); ++i) {
            RefInfo ref;
            if (this.get(i) == null || this.get(i).getType() != 9 || !className.equals((ref = (RefInfo)this.get(i)).getClassName()) || !fieldName.equals(ref.getTargetName()) || !type.equals(ref.getMethodType())) continue;
            return i;
        }
        return -1;
    }

    public int indexOfMethodRef(String className, String methodName, String type) {
        for (int i = 0; i < this.size(); ++i) {
            RefInfo ref;
            if (this.get(i) == null || this.get(i).getType() != 10 || !className.equals((ref = (RefInfo)this.get(i)).getClassName()) || !methodName.equals(ref.getTargetName()) || !type.equals(ref.getMethodType())) continue;
            return i;
        }
        return -1;
    }

    public int indexOfUtf8(String text) {
        for (int i = 0; i < this.size(); ++i) {
            UTF8Info utf8;
            if (this.get(i) == null || this.get(i).getType() != 1 || !text.equals((utf8 = (UTF8Info)this.get(i)).getValue())) continue;
            return i;
        }
        return -1;
    }

    public void dump(PrintStream out) {
        for (int i = 0; i < this.cpi.size(); ++i) {
            out.println(i + ": " + this.cpi.get(i));
        }
    }

    @Override
    public Iterator<ConstantPoolInfo> iterator() {
        return new Iterator<ConstantPoolInfo>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ConstantPool.this.size();
            }

            @Override
            public ConstantPoolInfo next() {
                return ConstantPool.this.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException(ConstantPool.class.getName() + " does not support remove.");
            }
        };
    }

    public void shrinkToSize(int size) {
        assert (size < this.size()) : "Size can't be bigger than current size";
        while (size < this.size()) {
            this.removeLast();
        }
    }

    public byte[] getData() {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addShort(this.size());
        for (int i = 1; i < this.size(); ++i) {
            ConstantPoolInfo cpi = this.get(i);
            ser.addBytes(cpi.getData());
            if (cpi.getType() != 5 && cpi.getType() != 6) continue;
            ++i;
        }
        return ser.getBytes();
    }

    public Map<Object, Range> getOffsetMap(int initialOffset) {
        HashMap<Object, Range> map = new HashMap<Object, Range>();
        int offset = initialOffset;
        offset += 2;
        for (int i = 1; i < this.size(); ++i) {
            ConstantPoolInfo cpi = this.get(i);
            int length = cpi.getData().length;
            map.put(cpi, new Range(offset, length));
            offset += length;
            if (cpi.getType() != 5 && cpi.getType() != 6) continue;
            ++i;
        }
        return map;
    }
}

