/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.constantpool;

import net.sf.rej.java.Descriptor;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.util.ByteSerializer;

public class ClassInfo
extends ConstantPoolInfo {
    private int nameIndex;

    public ClassInfo(int nameIndex, ConstantPool pool) {
        super(7, pool);
        this.nameIndex = nameIndex;
    }

    public String toString() {
        return "(class) nameindex " + this.nameIndex + "(" + this.pool.get(this.nameIndex) + ")";
    }

    public String getName() {
        String name = this.pool.get(this.nameIndex).getValue().replace('/', '.');
        if (name.startsWith("[")) {
            Descriptor desc = new Descriptor(name);
            return desc.getReturn().toString();
        }
        return name;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public void setNameIndex(int index) {
        this.nameIndex = index;
    }

    public byte[] getData() {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addByte(this.getType());
        ser.addShort(this.nameIndex);
        return ser.getBytes();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getValue() {
        return this.getName();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        try {
            return this.getName().equals(((ClassInfo)other).getName());
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public String getTypeString() {
        return "Class reference";
    }
}

