/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.attribute.generics;

import java.util.List;
import junit.framework.TestCase;
import net.sf.rej.java.attribute.generics.BoundTypeArgument;
import net.sf.rej.java.attribute.generics.FormalTypeParameter;
import net.sf.rej.java.attribute.generics.GenericJavaType;
import net.sf.rej.java.attribute.generics.SignatureParser;
import net.sf.rej.java.attribute.generics.TypeArgument;
import org.junit.Assert;
import org.junit.Test;

public class SignatureParserTest
extends TestCase {
    @Test
    public final void testHasMore() {
        SignatureParser parser = new SignatureParser("");
        Assert.assertFalse((String)"Empty signature returns false right away", (boolean)parser.hasMore());
        parser = new SignatureParser("Z");
        Assert.assertTrue((String)"One boolean left", (boolean)parser.hasMore());
        parser.getGenericType();
        Assert.assertFalse((String)"At the end of a signature", (boolean)parser.hasMore());
    }

    @Test
    public final void testGetDimensionCount() {
        SignatureParser parser = new SignatureParser("[[[B");
        int dimCount = parser.getDimensionCount();
        Assert.assertEquals((String)"Three dimensions", (Object)3, (Object)dimCount);
        parser = new SignatureParser("Ljava/lang/Object;");
        dimCount = parser.getDimensionCount();
        Assert.assertEquals((String)"No dimensions", (Object)0, (Object)dimCount);
    }

    @Test
    public final void testGetGenericType() {
        SignatureParser parser = new SignatureParser("ILjava/lang/String;TT;[[[JLjava/util/List<Ljava/lang/String;>;");
        GenericJavaType gjt = parser.getGenericType();
        Assert.assertEquals((String)"Simple primitive", (Object)"int", (Object)gjt.getBaseType().getType());
        gjt = parser.getGenericType();
        Assert.assertEquals((String)"Reference type", (Object)"java.lang.String", (Object)gjt.getBaseType().getType());
        gjt = parser.getGenericType();
        Assert.assertEquals((String)"Generic param identifier", (Object)"T", (Object)gjt.getBaseType().getType());
        gjt = parser.getGenericType();
        Assert.assertEquals((String)"Array of primitive", (Object)"long", (Object)gjt.getBaseType().getType());
        Assert.assertEquals((String)"Array of primitive", (Object)3, (Object)gjt.getBaseType().getDimensionCount());
        gjt = parser.getGenericType();
        Assert.assertEquals((String)"Reference type with type argument", (Object)"java.util.List", (Object)gjt.getBaseType().getType());
        List<TypeArgument> typeArgs = gjt.getTypeArguments();
        Assert.assertEquals((String)"Type argument count", (Object)1, (Object)typeArgs.size());
        TypeArgument typeArg = typeArgs.get(0);
        GenericJavaType genTypeArg = (GenericJavaType)typeArg;
        Assert.assertEquals((String)"Type argument 1", (Object)"java.lang.String", (Object)genTypeArg.getBaseType().getType());
    }

    @Test
    public final void testGetPrimitiveName() {
        Assert.assertEquals((Object)"byte", (Object)SignatureParser.getPrimitiveName('B'));
        Assert.assertEquals((Object)"char", (Object)SignatureParser.getPrimitiveName('C'));
        Assert.assertEquals((Object)"double", (Object)SignatureParser.getPrimitiveName('D'));
        Assert.assertEquals((Object)"float", (Object)SignatureParser.getPrimitiveName('F'));
        Assert.assertEquals((Object)"int", (Object)SignatureParser.getPrimitiveName('I'));
        Assert.assertEquals((Object)"long", (Object)SignatureParser.getPrimitiveName('J'));
        Assert.assertEquals((Object)"short", (Object)SignatureParser.getPrimitiveName('S'));
        Assert.assertEquals((Object)"boolean", (Object)SignatureParser.getPrimitiveName('Z'));
        Assert.assertEquals((Object)"void", (Object)SignatureParser.getPrimitiveName('V'));
    }

    @Test
    public final void testGetFirstIndex() {
        SignatureParser parser = new SignatureParser("OneTwoOneThreeCatDogBlues");
        Assert.assertEquals((String)"One target", (Object)0, (Object)parser.getFirstIndex("One"));
        Assert.assertEquals((String)"One target", (Object)17, (Object)parser.getFirstIndex("Dog"));
        Assert.assertEquals((String)"Two targets", (Object)0, (Object)parser.getFirstIndex("One", "Two"));
        Assert.assertEquals((String)"Two targets", (Object)3, (Object)parser.getFirstIndex("Dog", "Two"));
        Assert.assertEquals((String)"Three targets", (Object)3, (Object)parser.getFirstIndex("Dog", "Two", "Three"));
    }

    @Test
    public final void testGetGenericDefName() {
        SignatureParser parser = new SignatureParser("T:Ljava/lang/Object;");
        String name = parser.getTypeParameterIdentifier();
        Assert.assertEquals((String)"Type argument identifier", (Object)name, (Object)"T");
    }

    @Test
    public final void testGetFormalTypeParameter() {
        SignatureParser parser = new SignatureParser("<NAME:Ljava/lang/Object;>");
        List<FormalTypeParameter> typeParams = parser.getFormalTypeParameters();
        Assert.assertEquals((String)"Type param count", (Object)1, (Object)typeParams.size());
        FormalTypeParameter typeParam = typeParams.get(0);
        Assert.assertEquals((String)"Type param identifier", (Object)"NAME", (Object)typeParam.getIdentifier());
        String superClass = typeParam.getClassBound().getBaseType().getType();
        Assert.assertEquals((String)"Class bound", (Object)"java.lang.Object", (Object)superClass);
        parser = new SignatureParser("<T:Ljava/lang/Object;:Ljava/util/List;:Ljava/lang/Runnable;>");
        typeParams = parser.getFormalTypeParameters();
        Assert.assertEquals((String)"Type param count", (Object)1, (Object)typeParams.size());
        typeParam = typeParams.get(0);
        superClass = typeParam.getClassBound().getBaseType().getType();
        Assert.assertEquals((String)"Class bound", (Object)"java.lang.Object", (Object)superClass);
        List<GenericJavaType> intfs = typeParam.getInterfaceBounds();
        Assert.assertEquals((String)"Interface bound count", (Object)2, (Object)intfs.size());
        Assert.assertEquals((String)"Interfaces 1", (Object)"java.util.List", (Object)intfs.get(0).getBaseType().getType());
        Assert.assertEquals((String)"Interfaces 2", (Object)"java.lang.Runnable", (Object)intfs.get(1).getBaseType().getType());
        parser = new SignatureParser("<NAME::Ljava/lang/Runnable;>");
        typeParams = parser.getFormalTypeParameters();
        Assert.assertEquals((String)"Type param count", (Object)1, (Object)typeParams.size());
        typeParam = typeParams.get(0);
        Assert.assertNull((String)"No class bound", (Object)typeParam.getClassBound());
        List<GenericJavaType> intfs2 = typeParam.getInterfaceBounds();
        Assert.assertEquals((String)"Interface bound count", (Object)1, (Object)intfs2.size());
        Assert.assertEquals((String)"Interface 1", (Object)"java.lang.Runnable", (Object)intfs2.get(0).getBaseType().getType());
        parser = new SignatureParser("<CCC1:Ljava/lang/Number;CCC2::Ljava/util/List<Ljava/lang/String;>;>");
        typeParams = parser.getFormalTypeParameters();
        Assert.assertEquals((String)"Type param count", (Object)2, (Object)typeParams.size());
        typeParam = typeParams.get(0);
        Assert.assertEquals((String)"Type param identifier", (Object)"CCC1", (Object)typeParam.getIdentifier());
        superClass = typeParam.getClassBound().getBaseType().getType();
        Assert.assertEquals((String)"Class bound", (Object)"java.lang.Number", (Object)superClass);
        typeParam = typeParams.get(1);
        Assert.assertEquals((String)"Type param identifier", (Object)"CCC2", (Object)typeParam.getIdentifier());
        superClass = typeParam.getInterfaceBounds().get(0).toString();
        Assert.assertEquals((String)"Interface bound", (Object)"java.util.List<java.lang.String>", (Object)superClass);
    }

    @Test
    public final void testGetMethodParameters() {
        SignatureParser parser = new SignatureParser("(Lnet/sf/rej/guineapigs/SignaturePig2<-Ljava/lang/Integer;>;I)V");
        List<GenericJavaType> params = parser.getMethodParameters();
        Assert.assertEquals((String)"Param count", (Object)2, (Object)params.size());
        GenericJavaType param1 = params.get(0);
        Assert.assertEquals((String)"Param 1 base type", (Object)"net.sf.rej.guineapigs.SignaturePig2", (Object)param1.getBaseType().getType());
        List<TypeArgument> typeParams = param1.getTypeArguments();
        Assert.assertEquals((String)"Param 1 type parameters count", (Object)1, (Object)typeParams.size());
        BoundTypeArgument typeParam = (BoundTypeArgument)typeParams.get(0);
        Assert.assertEquals((String)"Param 1 type param type toString()", (Object)"? super java.lang.Integer", (Object)typeParam.toString());
        Assert.assertEquals((String)"Param 2 base type", (Object)"int", (Object)params.get(1).getBaseType().getType());
    }

    @Test
    public final void testGetMethodParametersWithEmptyParams() {
        SignatureParser parser = new SignatureParser("()V");
        List<GenericJavaType> params = parser.getMethodParameters();
        Assert.assertEquals((String)"No params", (Object)0, (Object)params.size());
    }
}

