/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.attribute.generics;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.java.attribute.generics.Any;
import net.sf.rej.java.attribute.generics.BoundTypeArgument;
import net.sf.rej.java.attribute.generics.FormalTypeParameter;
import net.sf.rej.java.attribute.generics.GenericJavaType;
import net.sf.rej.java.attribute.generics.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureParser {
    private String signature;
    private int pos = 0;

    public SignatureParser(String signature) {
        this.signature = signature;
    }

    public ElementType peekNextType() {
        switch (this.signature.charAt(this.pos)) {
            case 'L': {
                return ElementType.REFERENCE_TYPE;
            }
            case 'T': {
                return ElementType.TYPE_PARAMETER;
            }
            case '<': {
                return ElementType.START_DEF;
            }
            case '>': {
                return ElementType.END_DEF;
            }
            case ':': {
                return ElementType.DELIM_DEF;
            }
            case '*': {
                return ElementType.WILD_CARD;
            }
            case '+': 
            case '-': {
                return ElementType.BOUND;
            }
            case '(': {
                return ElementType.START_METHOD_PARAMS;
            }
            case ')': {
                return ElementType.END_METHOD_PARAMS;
            }
            case '[': {
                return ElementType.ARRAY;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return ElementType.PRIMITIVE;
            }
        }
        return ElementType.OTHER;
    }

    public boolean hasMore() {
        return this.pos < this.signature.length();
    }

    public int getDimensionCount() {
        int count = 0;
        while (this.peekNextType() == ElementType.ARRAY) {
            ++count;
            ++this.pos;
        }
        return count;
    }

    public GenericJavaType getGenericType() {
        GenericJavaType type = new GenericJavaType();
        int dimensions = this.getDimensionCount();
        ElementType et = this.peekNextType();
        ++this.pos;
        if (et == ElementType.REFERENCE_TYPE) {
            int next = this.getFirstIndex("<", ";");
            String typeStr = this.signature.substring(this.pos, next);
            typeStr = typeStr.replace('/', '.');
            type.setType(Types.REFERENCE_TYPE, dimensions, typeStr);
            if (this.signature.charAt(next) == '<') {
                this.pos = next + 1;
                while (this.signature.charAt(this.pos) != '>') {
                    ElementType typeParamType = this.peekNextType();
                    if (typeParamType == ElementType.WILD_CARD) {
                        type.addTypeArgument(new Any());
                        ++this.pos;
                        continue;
                    }
                    if (typeParamType == ElementType.BOUND) {
                        char bound = this.signature.charAt(this.pos);
                        ++this.pos;
                        GenericJavaType paramType = this.getGenericType();
                        type.addTypeArgument(new BoundTypeArgument(paramType, bound));
                        continue;
                    }
                    GenericJavaType paramType = this.getGenericType();
                    type.addTypeArgument(paramType);
                }
                this.pos += 2;
            } else {
                this.pos = next + 1;
            }
        } else if (et == ElementType.TYPE_PARAMETER) {
            int next = this.signature.indexOf(";", this.pos);
            String typeStr = this.signature.substring(this.pos, next);
            this.pos = next + 1;
            type.setType(Types.TYPE_PARAMETER_IDENTIFIER, dimensions, typeStr);
        } else if (et == ElementType.PRIMITIVE) {
            type.setType(Types.PRIMITIVE_TYPE, dimensions, SignatureParser.getPrimitiveName(this.signature.charAt(this.pos - 1)));
        } else {
            throw new RuntimeException("Invalid type: " + (Object)((Object)et) + " - " + this.signature.charAt(this.pos));
        }
        return type;
    }

    public static String getPrimitiveName(char c) {
        switch (c) {
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'Z': {
                return "boolean";
            }
            case 'V': {
                return "void";
            }
        }
        return null;
    }

    public int getFirstIndex(String ... targets) {
        int min = -1;
        for (String target : targets) {
            int index = this.signature.indexOf(target, this.pos);
            if (index == -1 || min != -1 && index >= min) continue;
            min = index;
        }
        return min;
    }

    public String getTypeParameterIdentifier() {
        int index = this.getFirstIndex(":");
        String name = this.signature.substring(this.pos, index);
        this.pos = index + 1;
        return name;
    }

    public List<FormalTypeParameter> getFormalTypeParameters() {
        if (this.peekNextType() != ElementType.START_DEF) {
            throw new RuntimeException("Invalid type parameter start char: " + this.signature.charAt(this.pos));
        }
        ArrayList<FormalTypeParameter> typeParams = new ArrayList<FormalTypeParameter>();
        ++this.pos;
        while (this.peekNextType() != ElementType.END_DEF) {
            typeParams.add(this.getFormalTypeParameter());
        }
        ++this.pos;
        return typeParams;
    }

    private FormalTypeParameter getFormalTypeParameter() {
        String name = this.getTypeParameterIdentifier();
        FormalTypeParameter typeParam = new FormalTypeParameter(name);
        ElementType et = this.peekNextType();
        if (et != ElementType.DELIM_DEF && et != ElementType.END_DEF) {
            typeParam.setClassBound(this.getGenericType());
        }
        while (this.peekNextType() == ElementType.DELIM_DEF) {
            ++this.pos;
            typeParam.addInterfaceBound(this.getGenericType());
        }
        return typeParam;
    }

    public List<GenericJavaType> getMethodParameters() {
        ElementType openParenthesis = this.peekNextType();
        if (openParenthesis != ElementType.START_METHOD_PARAMS) {
            throw new RuntimeException("Invalid method params start: " + this.signature.charAt(this.pos));
        }
        ++this.pos;
        ArrayList<GenericJavaType> params = new ArrayList<GenericJavaType>();
        while (this.peekNextType() != ElementType.END_METHOD_PARAMS) {
            params.add(this.getGenericType());
        }
        ++this.pos;
        return params;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ElementType {
        OTHER,
        REFERENCE_TYPE,
        TYPE_PARAMETER,
        START_DEF,
        END_DEF,
        DELIM_DEF,
        WILD_CARD,
        BOUND,
        START_METHOD_PARAMS,
        END_METHOD_PARAMS,
        ARRAY,
        PRIMITIVE;

    }
}

