/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.attribute;

import net.sf.rej.java.attribute.Attribute;
import net.sf.rej.java.attribute.generics.Signatures;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.util.ByteArrayByteParser;
import net.sf.rej.util.ByteSerializer;

public class SignatureAttribute
extends Attribute {
    private int signatureIndex;

    public SignatureAttribute(int nameIndex, ConstantPool pool) {
        super(nameIndex, pool);
    }

    public void setPayload(byte[] data) {
        ByteArrayByteParser parser = new ByteArrayByteParser(data);
        parser.setBigEndian(true);
        this.signatureIndex = parser.getShortAsInt();
    }

    public byte[] getPayload() {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addShort(this.signatureIndex);
        return ser.getBytes();
    }

    public String getSignatureString() {
        return this.pool.get(this.signatureIndex).getValue();
    }

    public String toString() {
        return "Signature = " + Signatures.getSignature(this.getSignatureString());
    }
}

