/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.attribute;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.java.LocalVariable;
import net.sf.rej.java.attribute.Attribute;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.instruction.Label;
import net.sf.rej.util.ByteArrayByteParser;
import net.sf.rej.util.ByteSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVariableTableAttribute
extends Attribute {
    private List<LocalVariable> localVariables = new ArrayList<LocalVariable>();

    public LocalVariableTableAttribute(int nameIndex, ConstantPool pool) {
        super(nameIndex, pool);
    }

    public LocalVariable getLocalVariable(int index, int pc) {
        for (LocalVariable lv : this.localVariables) {
            if (lv.getIndex() != index || !lv.isInRange(pc)) continue;
            return lv;
        }
        return null;
    }

    public List getLocalVariable(int pc) {
        ArrayList<LocalVariable> al = new ArrayList<LocalVariable>();
        for (LocalVariable lv : this.localVariables) {
            if (lv.getStartPc() != pc) continue;
            al.add(lv);
        }
        return al;
    }

    public List<LocalVariable> getLocalVariables() {
        ArrayList<LocalVariable> al = new ArrayList<LocalVariable>();
        al.addAll(this.localVariables);
        return al;
    }

    public List<Label> getVariableLabels() {
        ArrayList<Label> labels = new ArrayList<Label>();
        for (LocalVariable lv : this.localVariables) {
            labels.addAll(lv.getLabels());
        }
        return labels;
    }

    @Override
    public byte[] getPayload() {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addShort(this.localVariables.size());
        for (LocalVariable lv : this.localVariables) {
            ser.addBytes(lv.getData());
        }
        return ser.getBytes();
    }

    @Override
    public void setPayload(byte[] data) {
        ByteArrayByteParser parser = new ByteArrayByteParser(data);
        parser.setBigEndian(true);
        int length = parser.getShortAsInt();
        for (int i = 0; i < length; ++i) {
            LocalVariable lv = new LocalVariable(parser, this.pool);
            this.localVariables.add(lv);
        }
    }

    @Override
    public String toString() {
        return "LocalVariableTableAttribute(" + this.localVariables.size() + " definitions)";
    }
}

