/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.attribute;

import java.util.HashMap;
import java.util.Map;
import net.sf.rej.java.Code;
import net.sf.rej.java.attribute.Attribute;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.instruction.DecompilationContext;
import net.sf.rej.java.instruction.Instruction;
import net.sf.rej.util.ByteArrayByteParser;
import net.sf.rej.util.ByteSerializer;

public class LineNumberTableAttribute
extends Attribute {
    private Map<Integer, Integer> mappings = new HashMap<Integer, Integer>();
    private Map<Instruction, Integer> instructionMappings = new HashMap<Instruction, Integer>();
    private Code code = null;
    private boolean validated = false;

    public LineNumberTableAttribute(int nameIndex, ConstantPool pool) {
        super(nameIndex, pool);
    }

    public int getLineNumber(int pc) {
        this.validateIfNecessary();
        Integer ln = this.mappings.get(pc);
        if (ln != null) {
            return ln;
        }
        return -1;
    }

    public byte[] getPayload() {
        return this.getLineNumberData();
    }

    public void setPayload(byte[] data) {
        ByteArrayByteParser parser = new ByteArrayByteParser(data);
        parser.setBigEndian(true);
        int length = parser.getShortAsInt();
        for (int i = 0; i < length; ++i) {
            int pc = parser.getShortAsInt();
            int ln = parser.getShortAsInt();
            this.mappings.put(pc, ln);
        }
        this.validated = true;
    }

    public byte[] getLineNumberData() {
        this.validateIfNecessary();
        ByteSerializer ser = new ByteSerializer(true);
        ser.addShort(this.mappings.size());
        for (Map.Entry<Integer, Integer> entry : this.mappings.entrySet()) {
            ser.addShort(entry.getKey());
            ser.addShort(entry.getValue());
        }
        return ser.getBytes();
    }

    public String toString() {
        return "Linenumber table(" + this.mappings.size() + " entries)";
    }

    public void setCode(Code code) {
        this.code = code;
        this.instructionMappings.clear();
        DecompilationContext dc = code.createDecompilationContext();
        dc.setPosition(0);
        for (Instruction inst : code.getInstructions()) {
            Integer srcLine = this.mappings.get(dc.getPosition());
            if (srcLine != null) {
                this.instructionMappings.put(inst, srcLine);
            }
            dc.incrementPosition(inst);
        }
    }

    public void invalidate() {
        this.validated = false;
    }

    private void validateIfNecessary() {
        if (!this.validated) {
            this.validate();
        }
    }

    private void validate() {
        this.mappings.clear();
        DecompilationContext dc = this.code.createDecompilationContext();
        dc.setPosition(0);
        for (Instruction inst : this.code.getInstructions()) {
            Integer srcLine = this.instructionMappings.get(inst);
            if (srcLine != null) {
                this.mappings.put(dc.getPosition(), srcLine);
            }
            dc.incrementPosition(inst);
        }
        this.validated = true;
    }
}

