/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.attribute;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.java.attribute.Attribute;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.util.ByteArrayByteParser;

public class InnerClassesAttribute
extends Attribute {
    private List<InnerClass> innerClasses = new ArrayList<InnerClass>();

    public InnerClassesAttribute(int nameIndex, ConstantPool pool) {
        super(nameIndex, pool);
    }

    public void setPayload(byte[] data) {
        super.setPayload(data);
        ByteArrayByteParser parser = new ByteArrayByteParser(data);
        parser.setBigEndian(true);
        int numberOfExceptions = parser.getShortAsInt();
        for (int i = 0; i < numberOfExceptions; ++i) {
            int innerClassInfoIndex = parser.getShortAsInt();
            int outerClassInfoIndex = parser.getShortAsInt();
            int innerClassNameIndex = parser.getShortAsInt();
            int innerClassAccessFlags = parser.getShortAsInt();
            InnerClass ic = new InnerClass(innerClassInfoIndex, outerClassInfoIndex, innerClassNameIndex, innerClassAccessFlags);
            this.innerClasses.add(ic);
        }
    }

    public String toString() {
        return "InnerClasses (" + this.innerClasses.size() + " entries)";
    }

    public class InnerClass {
        private int innerClassInfoIndex;
        private int outerClassInfoIndex;
        private int innerClassNameIndex;
        private int innerClassAccessFlags;

        public InnerClass(int innerClassInfoIndex, int outerClassInfoIndex, int innerNameIndex, int innerFlags) {
            this.innerClassInfoIndex = innerClassInfoIndex;
            this.outerClassInfoIndex = outerClassInfoIndex;
            this.innerClassNameIndex = innerNameIndex;
            this.innerClassAccessFlags = innerFlags;
        }

        public int getInnerClassAccessFlags() {
            return this.innerClassAccessFlags;
        }

        public void setInnerClassAccessFlags(int innerClassAccessFlags) {
            this.innerClassAccessFlags = innerClassAccessFlags;
        }

        public int getInnerClassInfoIndex() {
            return this.innerClassInfoIndex;
        }

        public void setInnerClassInfoIndex(int innerClassInfoIndex) {
            this.innerClassInfoIndex = innerClassInfoIndex;
        }

        public int getInnerClassNameIndex() {
            return this.innerClassNameIndex;
        }

        public void setInnerClassNameIndex(int innerClassNameIndex) {
            this.innerClassNameIndex = innerClassNameIndex;
        }

        public int getOuterClassInfoIndex() {
            return this.outerClassInfoIndex;
        }

        public void setOuterClassInfoIndex(int outerClassInfoIndex) {
            this.outerClassInfoIndex = outerClassInfoIndex;
        }
    }
}

