/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.attribute;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.java.attribute.Attribute;
import net.sf.rej.java.attribute.ExceptionDescriptor;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.util.ByteArrayByteParser;
import net.sf.rej.util.ByteSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionsAttribute
extends Attribute {
    private List<ExceptionDescriptor> exceptions = new ArrayList<ExceptionDescriptor>();

    public ExceptionsAttribute(int nameIndex, ConstantPool pool) {
        super(nameIndex, pool);
    }

    public ExceptionsAttribute(int nameIndex, ConstantPool pool, List<ExceptionDescriptor> exceptions) {
        super(nameIndex, pool);
        this.exceptions.addAll(exceptions);
    }

    @Override
    public byte[] getPayload() {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addShort(this.exceptions.size());
        for (ExceptionDescriptor ex : this.exceptions) {
            ser.addShort(ex.getIndex());
        }
        return ser.getBytes();
    }

    @Override
    public void setPayload(byte[] data) {
        ByteArrayByteParser parser = new ByteArrayByteParser(data);
        parser.setBigEndian(true);
        int numberOfExceptions = parser.getShortAsInt();
        for (int i = 0; i < numberOfExceptions; ++i) {
            int index = parser.getShortAsInt();
            this.exceptions.add(new ExceptionDescriptor(this.pool, index));
        }
    }

    public List<ExceptionDescriptor> getExceptions() {
        ArrayList<ExceptionDescriptor> list = new ArrayList<ExceptionDescriptor>();
        list.addAll(this.exceptions);
        return list;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Exceptions (");
        for (ExceptionDescriptor ex : this.exceptions) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(ex);
        }
        sb.append(")");
        return sb.toString();
    }
}

