/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.attribute;

import net.sf.rej.java.Descriptor;
import net.sf.rej.java.attribute.Attribute;
import net.sf.rej.java.constantpool.ClassInfo;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.NameAndTypeInfo;
import net.sf.rej.util.ByteArrayByteParser;
import net.sf.rej.util.ByteSerializer;

public class EnclosingMethodAttribute
extends Attribute {
    private int classIndex = 0;
    private int methodIndex = 0;

    public EnclosingMethodAttribute(int nameIndex, ConstantPool pool) {
        super(nameIndex, pool);
    }

    public void setPayload(byte[] data) {
        ByteArrayByteParser parser = new ByteArrayByteParser(data);
        parser.setBigEndian(true);
        this.classIndex = parser.getShortAsInt();
        this.methodIndex = parser.getShortAsInt();
    }

    public byte[] getPayload() {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addShort(this.classIndex);
        ser.addShort(this.methodIndex);
        return ser.getBytes();
    }

    public boolean hasEnclosingMethod() {
        return this.methodIndex != 0;
    }

    public ClassInfo getEnclosingClass() {
        return (ClassInfo)this.pool.get(this.classIndex);
    }

    public NameAndTypeInfo getEnclosingMethod() {
        if (this.hasEnclosingMethod()) {
            return (NameAndTypeInfo)this.pool.get(this.methodIndex);
        }
        return null;
    }

    public String getEnclosingClassName() {
        return this.getEnclosingClass().getName();
    }

    public String getEnclosingMethodName() {
        if (this.hasEnclosingMethod()) {
            return this.getEnclosingMethod().getName();
        }
        return null;
    }

    public Descriptor getEnclosingMethodDesc() {
        if (this.hasEnclosingMethod()) {
            return this.getEnclosingMethod().getDescriptor();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Enclosing class = <");
        sb.append(this.getEnclosingClassName());
        sb.append(">");
        if (this.hasEnclosingMethod()) {
            sb.append(" Enclosing method = <");
            Descriptor desc = this.getEnclosingMethodDesc();
            String name = this.getEnclosingMethodName();
            sb.append(desc.getReturn());
            sb.append(" ");
            sb.append(name);
            sb.append("(");
            sb.append(desc.getParams());
            sb.append(")>");
        }
        return sb.toString();
    }
}

