/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.attribute;

import net.sf.rej.java.attribute.Attribute;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.util.ByteArrayByteParser;
import net.sf.rej.util.ByteToolkit;

public class ConstantValueAttribute
extends Attribute {
    private int constant;

    public ConstantValueAttribute(int nameIndex, ConstantPool pool) {
        super(nameIndex, pool);
    }

    public String toString() {
        ConstantPoolInfo cpi = this.pool.get(this.constant);
        return "Constant: " + cpi.getValue();
    }

    public String getValue() {
        ConstantPoolInfo cpi = this.pool.get(this.constant);
        return cpi.getValue();
    }

    public int getConstantIndex() {
        return this.constant;
    }

    public void setConstantIndex(int index) {
        this.constant = index;
    }

    public byte[] getPayload() {
        return ByteToolkit.longToTwoBytes(this.constant, true);
    }

    public void setPayload(byte[] data) {
        ByteArrayByteParser parser = new ByteArrayByteParser(data);
        parser.setBigEndian(true);
        this.constant = parser.getShortAsInt();
    }

    public ConstantPoolInfo getCPI() {
        return this.pool.get(this.constant);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConstantValueAttribute)) {
            return false;
        }
        ConstantValueAttribute other = (ConstantValueAttribute)obj;
        return other.getCPI().equals(this.getCPI());
    }

    public int hashCode() {
        return this.getCPI().hashCode();
    }
}

