/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.attribute;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import net.sf.rej.java.Code;
import net.sf.rej.java.Exceptions;
import net.sf.rej.java.attribute.Attribute;
import net.sf.rej.java.attribute.Attributes;
import net.sf.rej.java.attribute.LineNumberTableAttribute;
import net.sf.rej.java.attribute.LocalVariableTableAttribute;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.util.ByteArrayByteParser;
import net.sf.rej.util.ByteSerializer;
import net.sf.rej.util.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeAttribute
extends Attribute {
    private int maxStack;
    private int maxLocals;
    private Code code;
    private Exceptions exceptions;
    private Attributes attributes;

    public CodeAttribute(int nameIndex, ConstantPool pool) {
        super(nameIndex, pool);
    }

    public CodeAttribute(int nameIndex, ConstantPool cp, int maxStack, int maxLocals) {
        super(nameIndex, cp);
        this.maxStack = maxStack;
        this.maxLocals = maxLocals;
        this.code = new Code(cp);
        this.exceptions = new Exceptions();
        this.attributes = new Attributes();
    }

    @Override
    public byte[] getPayload() {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addShort(this.maxStack);
        ser.addShort(this.maxLocals);
        byte[] data = this.code.getData();
        ser.addInt(data.length);
        ser.addBytes(data);
        ser.addBytes(this.exceptions.getData());
        ser.addBytes(this.attributes.getData());
        return ser.getBytes();
    }

    public Map<Object, Range> getOffsetMap() {
        HashMap<Object, Range> map = new HashMap<Object, Range>();
        int offset = 6;
        map.put((Object)OffsetTag.MAX_STACK, new Range(offset, 2));
        map.put((Object)OffsetTag.MAX_LOCALS, new Range(offset += 2, 2));
        map.put((Object)OffsetTag.CODE_LENGTH, new Range(offset += 2, 4));
        int codeLength = this.code.getData().length;
        map.put((Object)OffsetTag.CODE, new Range(offset += 4, codeLength));
        int exceptionsLength = this.exceptions.getData().length;
        map.put((Object)OffsetTag.EXCEPTIONS, new Range(offset += codeLength, exceptionsLength));
        map.put((Object)OffsetTag.ATTRIBUTES, new Range(offset += exceptionsLength, this.attributes.getData().length));
        map.putAll(this.attributes.getOffsetMap(offset));
        return map;
    }

    @Override
    public void setPayload(byte[] data) {
        ByteArrayByteParser parser = new ByteArrayByteParser(data);
        parser.setBigEndian(true);
        this.maxStack = parser.getShortAsInt();
        this.maxLocals = parser.getShortAsInt();
        int codeLength = (int)parser.getInt();
        byte[] codeData = parser.getBytes(codeLength);
        ByteArrayByteParser newParser = new ByteArrayByteParser(codeData);
        newParser.setBigEndian(true);
        this.code = new Code(newParser, this.pool);
        this.exceptions = new Exceptions(parser, this.pool);
        this.attributes = new Attributes(parser, this.pool);
        LineNumberTableAttribute lnAttr = this.attributes.getLineNumberTable();
        if (lnAttr != null) {
            lnAttr.setCode(this.code);
            this.code.setLineNumberTable(lnAttr);
        }
        this.code.insertLabels(this.exceptions.getLabels());
        LocalVariableTableAttribute lvta = this.attributes.getLocalVariableTable();
        this.code.setLocalVariableTable(lvta);
        this.code.setExceptions(this.exceptions);
        if (lvta != null) {
            this.code.insertLabels(lvta.getVariableLabels());
        }
    }

    public Code getCode() {
        return this.code;
    }

    public int getMaxStackSize() {
        return this.maxStack;
    }

    public void setStackSize(int maxStack) {
        this.maxStack = maxStack;
    }

    public void dump(PrintStream out) {
        this.code.printCode(out, this.attributes.getLineNumberTable(), this.attributes.getLocalVariableTable());
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public Exceptions getExceptions() {
        return this.exceptions;
    }

    public void setMaxLocals(int locals) {
        this.maxLocals = locals;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    @Override
    public String toString() {
        return "Code(max locals=" + this.maxLocals + ", max stack=" + this.maxStack + ")";
    }

    public void setCode(Code code) {
        this.code = code;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OffsetTag {
        MAX_STACK,
        MAX_LOCALS,
        CODE_LENGTH,
        CODE,
        EXCEPTIONS,
        ATTRIBUTES;

    }
}

