/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.attribute;

import net.sf.rej.java.attribute.CodeAttribute;
import net.sf.rej.java.attribute.ConstantValueAttribute;
import net.sf.rej.java.attribute.DeprecatedAttribute;
import net.sf.rej.java.attribute.EnclosingMethodAttribute;
import net.sf.rej.java.attribute.ExceptionsAttribute;
import net.sf.rej.java.attribute.InnerClassesAttribute;
import net.sf.rej.java.attribute.LineNumberTableAttribute;
import net.sf.rej.java.attribute.LocalVariableTableAttribute;
import net.sf.rej.java.attribute.LocalVariableTypeTableAttribute;
import net.sf.rej.java.attribute.RuntimeInvisibleAnnotationsAttribute;
import net.sf.rej.java.attribute.RuntimeVisibleAnnotationsAttribute;
import net.sf.rej.java.attribute.SignatureAttribute;
import net.sf.rej.java.attribute.SourceFileAttribute;
import net.sf.rej.java.attribute.SyntheticAttribute;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.util.ByteParser;
import net.sf.rej.util.ByteSerializer;
import net.sf.rej.util.ByteToolkit;

public class Attribute {
    protected int nameIndex;
    private byte[] info;
    protected ConstantPool pool;

    protected Attribute(int nameIndex, ConstantPool pool) {
        this.pool = pool;
        this.nameIndex = nameIndex;
    }

    public static Attribute getAttribute(ByteParser parser, ConstantPool pool) {
        int nameIndex = parser.getShortAsInt();
        int count = (int)parser.getInt();
        byte[] info = parser.getBytes(count);
        String name = pool.get(nameIndex).getValue();
        if ("Code".equals(name)) {
            CodeAttribute attr = new CodeAttribute(nameIndex, pool);
            ((Attribute)attr).setPayload(info);
            return attr;
        }
        if ("LocalVariableTable".equals(name)) {
            LocalVariableTableAttribute attr = new LocalVariableTableAttribute(nameIndex, pool);
            ((Attribute)attr).setPayload(info);
            return attr;
        }
        if ("LineNumberTable".equals(name)) {
            LineNumberTableAttribute attr = new LineNumberTableAttribute(nameIndex, pool);
            ((Attribute)attr).setPayload(info);
            return attr;
        }
        if ("Exceptions".equals(name)) {
            ExceptionsAttribute attr = new ExceptionsAttribute(nameIndex, pool);
            ((Attribute)attr).setPayload(info);
            return attr;
        }
        if ("ConstantValue".equals(name)) {
            ConstantValueAttribute attr = new ConstantValueAttribute(nameIndex, pool);
            ((Attribute)attr).setPayload(info);
            return attr;
        }
        if ("InnerClasses".equals(name)) {
            InnerClassesAttribute attr = new InnerClassesAttribute(nameIndex, pool);
            ((Attribute)attr).setPayload(info);
            return attr;
        }
        if ("Synthetic".equals(name)) {
            SyntheticAttribute attr = new SyntheticAttribute(nameIndex, pool);
            attr.setPayload(info);
            return attr;
        }
        if ("SourceFile".equals(name)) {
            SourceFileAttribute attr = new SourceFileAttribute(nameIndex, pool);
            ((Attribute)attr).setPayload(info);
            return attr;
        }
        if ("Deprecated".equals(name)) {
            DeprecatedAttribute attr = new DeprecatedAttribute(nameIndex, pool);
            attr.setPayload(info);
            return attr;
        }
        if ("RuntimeVisibleAnnotations".equals(name)) {
            RuntimeVisibleAnnotationsAttribute attr = new RuntimeVisibleAnnotationsAttribute(nameIndex, pool);
            ((Attribute)attr).setPayload(info);
            return attr;
        }
        if ("RuntimeInvisibleAnnotations".equals(name)) {
            RuntimeInvisibleAnnotationsAttribute attr = new RuntimeInvisibleAnnotationsAttribute(nameIndex, pool);
            ((Attribute)attr).setPayload(info);
            return attr;
        }
        if ("EnclosingMethod".equals(name)) {
            EnclosingMethodAttribute attr = new EnclosingMethodAttribute(nameIndex, pool);
            ((Attribute)attr).setPayload(info);
            return attr;
        }
        if ("Signature".equals(name)) {
            SignatureAttribute attr = new SignatureAttribute(nameIndex, pool);
            ((Attribute)attr).setPayload(info);
            return attr;
        }
        if ("LocalVariableTypeTable".equals(name)) {
            LocalVariableTypeTableAttribute attr = new LocalVariableTypeTableAttribute(nameIndex, pool);
            ((Attribute)attr).setPayload(info);
            return attr;
        }
        Attribute attr = new Attribute(nameIndex, pool);
        attr.setPayload(info);
        return attr;
    }

    public String toString() {
        return "Attribute: nameIndex " + this.nameIndex + "(" + this.pool.get(this.nameIndex) + ") info " + ByteToolkit.byteArrayToDebugString(this.info);
    }

    public String getName() {
        return this.pool.get(this.nameIndex).getValue();
    }

    public final byte[] getData() {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addShort(this.nameIndex);
        byte[] payload = this.getPayload();
        ser.addInt(payload.length);
        ser.addBytes(payload);
        return ser.getBytes();
    }

    public byte[] getPayload() {
        return this.info;
    }

    public void setPayload(byte[] data) {
        this.info = data;
    }
}

